/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.JadxArgs;
import jadx.core.utils.exceptions.JadxArgsValidateException;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxArgsValidator {
    private static final Logger LOG = LoggerFactory.getLogger(JadxArgsValidator.class);

    public static void validate(JadxArgs args) {
        JadxArgsValidator.checkInputFiles(args);
        JadxArgsValidator.validateOutDirs(args);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Effective jadx args: {}", (Object)args);
        }
    }

    private static void checkInputFiles(JadxArgs args) {
        List<File> inputFiles = args.getInputFiles();
        if (inputFiles.isEmpty()) {
            throw new JadxArgsValidateException("Please specify input file");
        }
        for (File inputFile : inputFiles) {
            String fileName = inputFile.getName();
            if (!fileName.startsWith("--")) continue;
            throw new JadxArgsValidateException("Unknown argument: " + fileName);
        }
        for (File file : inputFiles) {
            JadxArgsValidator.checkFile(file);
        }
    }

    private static void validateOutDirs(JadxArgs args) {
        File outDir = args.getOutDir();
        File srcDir = args.getOutDirSrc();
        File resDir = args.getOutDirRes();
        if (outDir == null) {
            outDir = srcDir != null ? srcDir : (resDir != null ? resDir : JadxArgsValidator.makeDirFromInput(args));
            args.setOutDir(outDir);
        }
        if (srcDir == null) {
            args.setOutDirSrc(new File(args.getOutDir(), "sources"));
        }
        if (resDir == null) {
            args.setOutDirRes(new File(args.getOutDir(), "resources"));
        }
        JadxArgsValidator.checkDir(args.getOutDir(), "Output");
        JadxArgsValidator.checkDir(args.getOutDirSrc(), "Source output");
        JadxArgsValidator.checkDir(args.getOutDirRes(), "Resources output");
    }

    @NotNull
    private static File makeDirFromInput(JadxArgs args) {
        File file = args.getInputFiles().get(0);
        String name = file.getName();
        int pos = name.lastIndexOf(46);
        String outDirName = pos != -1 ? name.substring(0, pos) : name + '-' + "jadx-output";
        LOG.info("output directory: {}", (Object)outDirName);
        File outDir = new File(outDirName);
        return outDir;
    }

    private static void checkFile(File file) {
        if (!file.exists()) {
            throw new JadxArgsValidateException("File not found " + file.getAbsolutePath());
        }
    }

    private static void checkDir(File dir, String desc) {
        if (dir != null && dir.exists() && !dir.isDirectory()) {
            throw new JadxArgsValidateException(desc + " directory exists as file " + dir);
        }
    }

    private JadxArgsValidator() {
    }
}

