/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.LoopInfo;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.dex.regions.conditions.IfInfo;
import jadx.core.dex.visitors.regions.RegionMaker;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfMakerHelper {
    private static final Logger LOG = LoggerFactory.getLogger(IfMakerHelper.class);

    private IfMakerHelper() {
    }

    @Nullable
    static IfInfo makeIfInfo(MethodNode mth, BlockNode ifBlock) {
        InsnNode lastInsn = BlockUtils.getLastInsn(ifBlock);
        if (lastInsn == null || lastInsn.getType() != InsnType.IF) {
            return null;
        }
        IfNode ifNode = (IfNode)lastInsn;
        IfCondition condition = IfCondition.fromIfNode(ifNode);
        IfInfo info = new IfInfo(mth, condition, ifNode.getThenBlock(), ifNode.getElseBlock());
        info.getMergedBlocks().add(ifBlock);
        return info;
    }

    static IfInfo searchNestedIf(IfInfo info) {
        IfInfo next = IfMakerHelper.mergeNestedIfNodes(info);
        if (next != null) {
            return next;
        }
        return info;
    }

    static IfInfo restructureIf(MethodNode mth, BlockNode block, IfInfo info) {
        BlockNode elseBlock;
        BlockNode thenBlock = info.getThenBlock();
        if (Objects.equals(thenBlock, elseBlock = info.getElseBlock())) {
            IfInfo ifInfo = new IfInfo(info, null, null);
            ifInfo.setOutBlock(thenBlock);
            return ifInfo;
        }
        if (thenBlock.contains(AFlag.RETURN) && elseBlock.contains(AFlag.RETURN)) {
            info.setOutBlock(null);
            return info;
        }
        boolean badThen = IfMakerHelper.isBadBranchBlock(info, thenBlock);
        boolean badElse = IfMakerHelper.isBadBranchBlock(info, elseBlock);
        if (badThen && badElse) {
            LOG.debug("Stop processing blocks after 'if': {}, method: {}", info.getMergedBlocks(), (Object)mth);
            return null;
        }
        if (badElse) {
            info = new IfInfo(info, thenBlock, null);
            info.setOutBlock(elseBlock);
        } else if (badThen) {
            info = IfInfo.invert(info);
            info = new IfInfo(info, elseBlock, null);
            info.setOutBlock(thenBlock);
        } else {
            info.setOutBlock(BlockUtils.getPathCross(mth, thenBlock, elseBlock));
        }
        if (BlockUtils.isBackEdge(block, info.getOutBlock())) {
            info.setOutBlock(null);
        }
        return info;
    }

    private static boolean isBadBranchBlock(IfInfo info, BlockNode block) {
        BlockNode pred;
        if (block.contains(AFlag.LOOP_START) && block.getPredecessors().size() == 1 && (pred = block.getPredecessors().get(0)).contains(AFlag.LOOP_END)) {
            List startLoops = block.getAll(AType.LOOP);
            List endLoops = pred.getAll(AType.LOOP);
            for (LoopInfo startLoop : startLoops) {
                for (LoopInfo endLoop : endLoops) {
                    if (startLoop != endLoop) continue;
                    return true;
                }
            }
        }
        return !IfMakerHelper.allPathsFromIf(block, info);
    }

    private static boolean allPathsFromIf(BlockNode block, IfInfo info) {
        List<BlockNode> preds = block.getPredecessors();
        List<BlockNode> ifBlocks = info.getMergedBlocks();
        for (BlockNode pred : preds) {
            BlockNode top = BlockUtils.skipSyntheticPredecessor(pred);
            if (ifBlocks.contains(top) || top.contains(AFlag.LOOP_END)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static IfInfo mergeNestedIfNodes(IfInfo currentIf) {
        boolean assignInlineNeeded;
        boolean followThenBranch;
        BlockNode curElse;
        BlockNode curThen = currentIf.getThenBlock();
        if (curThen == (curElse = currentIf.getElseBlock())) {
            return null;
        }
        if (BlockUtils.isFollowBackEdge(curThen) || BlockUtils.isFollowBackEdge(curElse)) {
            return null;
        }
        IfInfo nextIf = IfMakerHelper.getNextIf(currentIf, curThen);
        if (nextIf != null) {
            followThenBranch = true;
        } else {
            nextIf = IfMakerHelper.getNextIf(currentIf, curElse);
            if (nextIf == null) return null;
            followThenBranch = false;
        }
        boolean bl = assignInlineNeeded = !nextIf.getForceInlineInsns().isEmpty();
        if (assignInlineNeeded) {
            for (BlockNode mergedBlock : currentIf.getMergedBlocks()) {
                if (!mergedBlock.contains(AFlag.LOOP_START)) continue;
                return currentIf;
            }
        }
        if (IfMakerHelper.isInversionNeeded(currentIf, nextIf)) {
            nextIf = IfInfo.invert(nextIf);
        }
        boolean thenPathSame = RegionMaker.isEqualPaths(curThen, nextIf.getThenBlock());
        boolean elsePathSame = RegionMaker.isEqualPaths(curElse, nextIf.getElseBlock());
        if (!thenPathSame && !elsePathSame) {
            if (IfMakerHelper.checkConditionBranches(curThen, curElse) || IfMakerHelper.checkConditionBranches(curElse, curThen)) {
                return null;
            }
            BlockNode otherBranchBlock = followThenBranch ? curElse : curThen;
            otherBranchBlock = BlockUtils.followEmptyPath(otherBranchBlock);
            if (!BlockUtils.isPathExists(nextIf.getFirstIfBlock(), otherBranchBlock)) {
                return IfMakerHelper.checkForTernaryInCondition(currentIf);
            }
            IfInfo tmpIf = IfMakerHelper.mergeNestedIfNodes(nextIf);
            if (tmpIf == null) return currentIf;
            nextIf = tmpIf;
            if (IfMakerHelper.isInversionNeeded(currentIf, nextIf)) {
                nextIf = IfInfo.invert(nextIf);
            }
            if (!IfMakerHelper.canMerge(currentIf, nextIf, followThenBranch)) {
                return currentIf;
            }
        } else if (assignInlineNeeded) {
            boolean sameOuts;
            boolean bl2 = sameOuts = thenPathSame && !followThenBranch || elsePathSame && followThenBranch;
            if (!sameOuts) {
                currentIf.resetForceInlineInsns();
                return currentIf;
            }
        }
        IfInfo result = IfMakerHelper.mergeIfInfo(currentIf, nextIf, followThenBranch);
        return IfMakerHelper.searchNestedIf(result);
    }

    private static IfInfo checkForTernaryInCondition(IfInfo currentIf) {
        IfInfo nextThen = IfMakerHelper.getNextIf(currentIf, currentIf.getThenBlock());
        IfInfo nextElse = IfMakerHelper.getNextIf(currentIf, currentIf.getElseBlock());
        if (nextThen == null || nextElse == null) {
            return null;
        }
        if (!nextThen.getFirstIfBlock().getDomFrontier().equals(nextElse.getFirstIfBlock().getDomFrontier())) {
            return null;
        }
        nextThen = IfMakerHelper.searchNestedIf(nextThen);
        nextElse = IfMakerHelper.searchNestedIf(nextElse);
        if (nextThen.getThenBlock() == nextElse.getThenBlock() && nextThen.getElseBlock() == nextElse.getElseBlock()) {
            return IfMakerHelper.mergeTernaryConditions(currentIf, nextThen, nextElse);
        }
        if (nextThen.getThenBlock() == nextElse.getElseBlock() && nextThen.getElseBlock() == nextElse.getThenBlock()) {
            nextElse = IfInfo.invert(nextElse);
            return IfMakerHelper.mergeTernaryConditions(currentIf, nextThen, nextElse);
        }
        return null;
    }

    private static IfInfo mergeTernaryConditions(IfInfo currentIf, IfInfo nextThen, IfInfo nextElse) {
        IfCondition newCondition = IfCondition.ternary(currentIf.getCondition(), nextThen.getCondition(), nextElse.getCondition());
        IfInfo result = new IfInfo(currentIf.getMth(), newCondition, nextThen.getThenBlock(), nextThen.getElseBlock());
        result.merge(currentIf, nextThen, nextElse);
        IfMakerHelper.confirmMerge(result);
        return result;
    }

    private static boolean isInversionNeeded(IfInfo currentIf, IfInfo nextIf) {
        return RegionMaker.isEqualPaths(currentIf.getElseBlock(), nextIf.getThenBlock()) || RegionMaker.isEqualPaths(currentIf.getThenBlock(), nextIf.getElseBlock());
    }

    private static boolean canMerge(IfInfo a, IfInfo b, boolean followThenBranch) {
        if (followThenBranch) {
            return RegionMaker.isEqualPaths(a.getElseBlock(), b.getElseBlock());
        }
        return RegionMaker.isEqualPaths(a.getThenBlock(), b.getThenBlock());
    }

    private static boolean checkConditionBranches(BlockNode from, BlockNode to) {
        return from.getCleanSuccessors().size() == 1 && from.getCleanSuccessors().contains(to);
    }

    private static IfInfo mergeIfInfo(IfInfo first, IfInfo second, boolean followThenBranch) {
        BlockNode elseBlock;
        BlockNode thenBlock;
        MethodNode mth = first.getMth();
        Set<BlockNode> skipBlocks = first.getSkipBlocks();
        if (followThenBranch) {
            thenBlock = second.getThenBlock();
            elseBlock = IfMakerHelper.getBranchBlock(first.getElseBlock(), second.getElseBlock(), skipBlocks, mth);
        } else {
            thenBlock = IfMakerHelper.getBranchBlock(first.getThenBlock(), second.getThenBlock(), skipBlocks, mth);
            elseBlock = second.getElseBlock();
        }
        IfCondition.Mode mergeOperation = followThenBranch ? IfCondition.Mode.AND : IfCondition.Mode.OR;
        IfCondition condition = IfCondition.merge(mergeOperation, first.getCondition(), second.getCondition());
        IfInfo result = new IfInfo(mth, condition, thenBlock, elseBlock);
        result.merge(first, second);
        return result;
    }

    private static BlockNode getBranchBlock(BlockNode first, BlockNode second, Set<BlockNode> skipBlocks, MethodNode mth) {
        BlockNode secondSkip;
        if (first == second) {
            return second;
        }
        if (RegionMaker.isEqualReturnBlocks(first, second)) {
            skipBlocks.add(first);
            return second;
        }
        BlockNode cross = BlockUtils.getPathCross(mth, first, second);
        if (cross != null) {
            BlockUtils.visitBlocksOnPath(mth, first, cross, skipBlocks::add);
            BlockUtils.visitBlocksOnPath(mth, second, cross, skipBlocks::add);
            skipBlocks.remove(cross);
            return cross;
        }
        BlockNode firstSkip = BlockUtils.followEmptyPath(first);
        if (firstSkip.equals(secondSkip = BlockUtils.followEmptyPath(second)) || RegionMaker.isEqualReturnBlocks(firstSkip, secondSkip)) {
            skipBlocks.add(first);
            skipBlocks.add(second);
            BlockUtils.visitBlocksOnEmptyPath(first, skipBlocks::add);
            BlockUtils.visitBlocksOnEmptyPath(second, skipBlocks::add);
            return secondSkip;
        }
        throw new JadxRuntimeException("Unexpected merge pattern");
    }

    static void confirmMerge(IfInfo info) {
        if (info.getMergedBlocks().size() > 1) {
            for (BlockNode block : info.getMergedBlocks()) {
                if (block == info.getFirstIfBlock()) continue;
                block.add(AFlag.ADDED_TO_REGION);
            }
        }
        if (!info.getSkipBlocks().isEmpty()) {
            for (BlockNode block : info.getSkipBlocks()) {
                block.add(AFlag.ADDED_TO_REGION);
            }
            info.getSkipBlocks().clear();
        }
        for (InsnNode forceInlineInsn : info.getForceInlineInsns()) {
            forceInlineInsn.add(AFlag.FORCE_ASSIGN_INLINE);
        }
    }

    private static IfInfo getNextIf(IfInfo info, BlockNode block) {
        if (!IfMakerHelper.canSelectNext(info, block)) {
            return null;
        }
        return IfMakerHelper.getNextIfNodeInfo(info, block);
    }

    private static boolean canSelectNext(IfInfo info, BlockNode block) {
        if (block.getPredecessors().size() == 1) {
            return true;
        }
        return info.getMergedBlocks().containsAll(block.getPredecessors());
    }

    private static IfInfo getNextIfNodeInfo(IfInfo info, BlockNode block) {
        if (block == null || block.contains(AType.LOOP) || block.contains(AFlag.ADDED_TO_REGION)) {
            return null;
        }
        InsnNode lastInsn = BlockUtils.getLastInsn(block);
        if (lastInsn != null && lastInsn.getType() == InsnType.IF) {
            return IfMakerHelper.makeIfInfo(info.getMth(), block);
        }
        List<BlockNode> successors = block.getSuccessors();
        if (successors.size() != 1) {
            return null;
        }
        BlockNode next = successors.get(0);
        if (next.getPredecessors().size() != 1) {
            return null;
        }
        if (next.contains(AFlag.ADDED_TO_REGION)) {
            return null;
        }
        List<InsnNode> insns = block.getInstructions();
        boolean pass = true;
        ArrayList<InsnNode> forceInlineInsns = new ArrayList<InsnNode>();
        if (!insns.isEmpty()) {
            for (InsnNode insn : insns) {
                RegisterArg res = insn.getResult();
                if (res == null) {
                    pass = false;
                    break;
                }
                List<RegisterArg> useList = res.getSVar().getUseList();
                int useCount = useList.size();
                if (useCount == 0) {
                    pass = false;
                    break;
                }
                InsnArg arg = useList.get(0);
                InsnNode usePlace = arg.getParentInsn();
                if (!BlockUtils.blockContains(block, usePlace) && !BlockUtils.blockContains(next, usePlace)) {
                    pass = false;
                    break;
                }
                if (useCount <= 1) continue;
                forceInlineInsns.add(insn);
            }
        }
        if (!pass) {
            return null;
        }
        IfInfo nextInfo = IfMakerHelper.makeIfInfo(info.getMth(), next);
        if (nextInfo == null) {
            return IfMakerHelper.getNextIfNodeInfo(info, next);
        }
        nextInfo.addInsnsForForcedInline(forceInlineInsns);
        return nextInfo;
    }
}

