/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.nodes.AnonymousClassBaseAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.usage.UsageInfoVisitor;
import jadx.core.utils.ListUtils;
import jadx.core.utils.exceptions.JadxException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@JadxVisitor(name="ProcessAnonymous", desc="Mark anonymous and lambda classes (for future inline)", runAfter={UsageInfoVisitor.class})
public class ProcessAnonymous
extends AbstractVisitor {
    private boolean inlineAnonymous;

    @Override
    public void init(RootNode root) {
        this.inlineAnonymous = root.getArgs().isInlineAnonymousClasses();
    }

    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        if (!this.inlineAnonymous) {
            return false;
        }
        ProcessAnonymous.markAnonymousClass(cls);
        return true;
    }

    private static void markAnonymousClass(ClassNode cls) {
        boolean synthetic;
        boolean bl = synthetic = cls.getAccessFlags().isSynthetic() || cls.getClassInfo().getShortName().contains("$") || Character.isDigit(cls.getClassInfo().getShortName().charAt(0));
        if (!synthetic) {
            return;
        }
        MethodNode anonymousConstructor = ProcessAnonymous.checkUsage(cls);
        if (anonymousConstructor == null) {
            return;
        }
        ArgType baseType = ProcessAnonymous.getBaseType(cls);
        if (baseType == null) {
            return;
        }
        cls.add(AFlag.ANONYMOUS_CLASS);
        cls.addAttr((IJadxAttribute)new AnonymousClassBaseAttr(baseType));
        cls.add(AFlag.DONT_GENERATE);
        anonymousConstructor.add(AFlag.ANONYMOUS_CONSTRUCTOR);
        ClassNode outerCls = anonymousConstructor.getUseIn().get(0).getParentClass();
        ClassNode topOuterCls = outerCls.getTopParentClass();
        ListUtils.safeRemove(cls.getDependencies(), topOuterCls);
        ListUtils.safeRemove(outerCls.getUseIn(), cls);
        if (cls.isTopClass()) {
            topOuterCls.setDependencies(ListUtils.safeRemoveAndTrim(topOuterCls.getDependencies(), cls));
            topOuterCls.setCodegenDeps(ListUtils.safeAdd(topOuterCls.getCodegenDeps(), cls));
        }
    }

    private static MethodNode checkUsage(ClassNode cls) {
        MethodNode ctr = ListUtils.filterOnlyOne(cls.getMethods(), MethodNode::isConstructor);
        if (ctr == null) {
            return null;
        }
        if (ctr.getUseIn().size() != 1 && !ProcessAnonymous.checkForCommonFieldInit(ctr)) {
            return null;
        }
        MethodNode ctrUseMth = ctr.getUseIn().get(0);
        ClassNode ctrUseCls = ctrUseMth.getParentClass();
        if (ctrUseCls.equals(cls)) {
            return null;
        }
        for (MethodNode mth : cls.getMethods()) {
            if (mth == ctr) continue;
            for (MethodNode useMth : mth.getUseIn()) {
                if (useMth.equals(ctrUseMth) || !ProcessAnonymous.badMethodUsage(cls, useMth, mth.getAccessFlags())) continue;
                return null;
            }
        }
        for (FieldNode field : cls.getFields()) {
            for (MethodNode useMth : field.getUseIn()) {
                if (!ProcessAnonymous.badMethodUsage(cls, useMth, field.getAccessFlags())) continue;
                return null;
            }
        }
        return ctr;
    }

    private static boolean badMethodUsage(ClassNode cls, MethodNode useMth, AccessInfo accessFlags) {
        ClassNode useCls = useMth.getParentClass();
        if (useCls.equals(cls)) {
            return false;
        }
        if (accessFlags.isSynthetic()) {
            return !useCls.getParentClass().equals(cls);
        }
        return true;
    }

    private static boolean checkForCommonFieldInit(MethodNode ctrMth) {
        List<MethodNode> ctrUse = ctrMth.getUseIn();
        if (ctrUse.isEmpty()) {
            return false;
        }
        ClassNode firstUseCls = ctrUse.get(0).getParentClass();
        return ListUtils.allMatch(ctrUse, m -> m.isConstructor() && m.getParentClass().equals(firstUseCls));
    }

    @Nullable
    private static ArgType getBaseType(ClassNode cls) {
        int interfacesCount = cls.getInterfaces().size();
        if (interfacesCount > 1) {
            return null;
        }
        ArgType superCls = cls.getSuperClass();
        if (superCls == null || superCls.equals(ArgType.OBJECT)) {
            if (interfacesCount == 1) {
                return cls.getInterfaces().get(0);
            }
            return ArgType.OBJECT;
        }
        if (interfacesCount == 0) {
            return superCls;
        }
        ArgType interfaceType = cls.getInterfaces().get(0);
        if (cls.root().getClsp().isImplements(superCls.getObject(), interfaceType.getObject())) {
            return superCls;
        }
        return null;
    }
}

