/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import jadx.api.ICodeCache;
import jadx.api.ICodeInfo;
import jadx.api.ICodeWriter;
import jadx.api.plugins.input.data.IClassData;
import jadx.api.plugins.input.data.ISeqConsumer;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.api.plugins.input.data.attributes.types.AnnotationDefaultAttr;
import jadx.api.plugins.input.data.attributes.types.AnnotationDefaultClassAttr;
import jadx.api.plugins.input.data.attributes.types.InnerClassesAttr;
import jadx.api.plugins.input.data.attributes.types.InnerClsInfo;
import jadx.api.plugins.input.data.attributes.types.SourceFileAttr;
import jadx.api.plugins.input.data.impl.ListConsumer;
import jadx.core.ProcessClass;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AttrNode;
import jadx.core.dex.attributes.nodes.NotificationAttrNode;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.ICodeNode;
import jadx.core.dex.nodes.ILoadable;
import jadx.core.dex.nodes.LoadStage;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.ProcessState;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.nodes.utils.TypeUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassNode
extends NotificationAttrNode
implements ILoadable,
ICodeNode,
Comparable<ClassNode> {
    private static final Logger LOG = LoggerFactory.getLogger(ClassNode.class);
    private final RootNode root;
    private final IClassData clsData;
    private final ClassInfo clsInfo;
    private AccessInfo accessFlags;
    private ArgType superClass;
    private List<ArgType> interfaces;
    private List<ArgType> generics = Collections.emptyList();
    private List<MethodNode> methods;
    private List<FieldNode> fields;
    private List<ClassNode> innerClasses = Collections.emptyList();
    private List<ClassNode> inlinedClasses = Collections.emptyList();
    private String smali;
    private ClassNode parentClass;
    private volatile ProcessState state = ProcessState.NOT_LOADED;
    private LoadStage loadStage = LoadStage.NONE;
    private List<ClassNode> dependencies = Collections.emptyList();
    private List<ClassNode> codegenDeps = Collections.emptyList();
    private List<ClassNode> useIn = Collections.emptyList();
    private List<MethodNode> useInMth = Collections.emptyList();
    private Map<MethodInfo, MethodNode> mthInfoMap = Collections.emptyMap();

    public ClassNode(RootNode root, IClassData cls) {
        this.root = root;
        this.clsInfo = ClassInfo.fromType(root, ArgType.object(cls.getType()));
        this.clsData = cls.copy();
        this.initialLoad(this.clsData);
    }

    private void initialLoad(IClassData cls) {
        try {
            this.addAttrs(cls.getAttributes());
            this.accessFlags = new AccessInfo(this.getAccessFlags(cls), AccessInfo.AFType.CLASS);
            this.superClass = this.checkSuperType(cls);
            this.interfaces = Utils.collectionMap(cls.getInterfacesTypes(), ArgType::object);
            ListConsumer fieldsConsumer = new ListConsumer(fld -> FieldNode.build(this, fld));
            ListConsumer methodsConsumer = new ListConsumer(mth -> MethodNode.build(this, mth));
            cls.visitFieldsAndMethods((ISeqConsumer)fieldsConsumer, (ISeqConsumer)methodsConsumer);
            if (this.fields != null && this.methods != null) {
                this.restoreUsageData(this.fields, this.methods, fieldsConsumer.getResult(), methodsConsumer.getResult());
            }
            this.fields = fieldsConsumer.getResult();
            this.methods = methodsConsumer.getResult();
            this.initStaticValues(this.fields);
            ClassNode.processAttributes(this);
            this.buildCache();
            if (this.accessFlags.isModuleInfo()) {
                this.addWarnComment("Modules not supported yet");
            }
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Error decode class: " + this.clsInfo, e);
        }
    }

    private void restoreUsageData(List<FieldNode> oldFields, List<MethodNode> oldMethods, List<FieldNode> newFields, List<MethodNode> newMethods) {
        Map<FieldInfo, FieldNode> oldFieldMap = Utils.groupBy(oldFields, FieldNode::getFieldInfo);
        for (FieldNode newField : newFields) {
            FieldNode oldField = oldFieldMap.get(newField.getFieldInfo());
            if (oldField == null) continue;
            newField.setUseIn(oldField.getUseIn());
        }
        Map<MethodInfo, MethodNode> oldMethodsMap = Utils.groupBy(oldMethods, MethodNode::getMethodInfo);
        for (MethodNode newMethod : newMethods) {
            MethodNode oldMethod = oldMethodsMap.get(newMethod.getMethodInfo());
            if (oldMethod == null) continue;
            newMethod.setUseIn(oldMethod.getUseIn());
        }
    }

    private ArgType checkSuperType(IClassData cls) {
        String superType = cls.getSuperType();
        if (superType == null) {
            if (this.clsInfo.getType().getObject().equals("java.lang.Object")) {
                return null;
            }
            if (this.accessFlags.isModuleInfo()) {
                return null;
            }
            throw new JadxRuntimeException("No super class in " + this.clsInfo.getType());
        }
        return ArgType.object(superType);
    }

    public void updateGenericClsData(ArgType superClass, List<ArgType> interfaces, List<ArgType> generics) {
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.generics = generics;
    }

    private static void processAttributes(ClassNode cls) {
        AnnotationDefaultClassAttr defAttr = (AnnotationDefaultClassAttr)cls.get(JadxAttrType.ANNOTATION_DEFAULT_CLASS);
        if (defAttr != null) {
            cls.remove(JadxAttrType.ANNOTATION_DEFAULT_CLASS);
            for (Map.Entry entry : defAttr.getValues().entrySet()) {
                MethodNode mth = cls.searchMethodByShortName((String)entry.getKey());
                if (mth != null) {
                    mth.addAttr((IJadxAttribute)new AnnotationDefaultAttr((EncodedValue)entry.getValue()));
                    continue;
                }
                cls.addWarnComment("Method from annotation default annotation not found: " + (String)entry.getKey());
            }
        }
        if (!cls.checkSourceFilenameAttr()) {
            cls.remove(JadxAttrType.SOURCE_FILE);
        }
    }

    private int getAccessFlags(IClassData cls) {
        InnerClsInfo innerClsInfo;
        InnerClassesAttr innerClassesAttr = (InnerClassesAttr)this.get(JadxAttrType.INNER_CLASSES);
        if (innerClassesAttr != null && (innerClsInfo = (InnerClsInfo)innerClassesAttr.getMap().get(cls.getType())) != null) {
            return innerClsInfo.getAccessFlags();
        }
        return cls.getAccessFlags();
    }

    public static ClassNode addSyntheticClass(RootNode root, String name, int accessFlags) {
        ClassInfo clsInfo = ClassInfo.fromName(root, name);
        ClassNode existCls = root.resolveClass(clsInfo);
        if (existCls != null) {
            throw new JadxRuntimeException("Class already exist: " + name);
        }
        return ClassNode.addSyntheticClass(root, clsInfo, accessFlags);
    }

    public static ClassNode addSyntheticClass(RootNode root, ClassInfo clsInfo, int accessFlags) {
        ClassNode cls = new ClassNode(root, clsInfo, accessFlags);
        cls.add(AFlag.SYNTHETIC);
        cls.setState(ProcessState.PROCESS_COMPLETE);
        root.addClassNode(cls);
        return cls;
    }

    private ClassNode(RootNode root, ClassInfo clsInfo, int accessFlags) {
        this.root = root;
        this.clsData = null;
        this.clsInfo = clsInfo;
        this.interfaces = new ArrayList<ArgType>();
        this.methods = new ArrayList<MethodNode>();
        this.fields = new ArrayList<FieldNode>();
        this.accessFlags = new AccessInfo(accessFlags, AccessInfo.AFType.CLASS);
        this.parentClass = this;
    }

    private void initStaticValues(List<FieldNode> fields) {
        if (fields.isEmpty()) {
            return;
        }
        List<FieldNode> staticFields = fields.stream().filter(FieldNode::isStatic).collect(Collectors.toList());
        for (FieldNode f : staticFields) {
            if (!f.getAccessFlags().isFinal() || f.get(JadxAttrType.CONSTANT_VALUE) != null) continue;
            f.addAttr((IJadxAttribute)EncodedValue.NULL);
        }
        try {
            this.root().getConstValues().processConstFields(this, staticFields);
        }
        catch (Exception e) {
            this.addWarnComment("Failed to load initial values for static fields", e);
        }
    }

    private boolean checkSourceFilenameAttr() {
        SourceFileAttr sourceFileAttr = (SourceFileAttr)this.get(JadxAttrType.SOURCE_FILE);
        if (sourceFileAttr == null) {
            return true;
        }
        String fileName = sourceFileAttr.getFileName();
        if (fileName.endsWith(".java")) {
            fileName = fileName.substring(0, fileName.length() - 5);
        }
        if (fileName.isEmpty() || fileName.equals("SourceFile")) {
            return false;
        }
        if (this.clsInfo != null) {
            String name = this.clsInfo.getShortName();
            if (fileName.equals(name)) {
                return false;
            }
            for (ClassInfo parentCls = this.clsInfo.getParentClass(); parentCls != null; parentCls = parentCls.getParentClass()) {
                String parentName = parentCls.getShortName();
                if (!parentName.equals(fileName) && !parentName.startsWith(fileName + '$')) continue;
                return false;
            }
            if (fileName.contains("$") && fileName.endsWith('$' + name)) {
                return false;
            }
            if (name.contains("$") && name.startsWith(fileName)) {
                return false;
            }
        }
        return true;
    }

    public boolean checkProcessed() {
        return this.getTopParentClass().getState().isProcessComplete();
    }

    public void ensureProcessed() {
        if (!this.checkProcessed()) {
            ClassNode topParentClass = this.getTopParentClass();
            throw new JadxRuntimeException("Expected class to be processed at this point, class: " + topParentClass + ", state: " + (Object)((Object)topParentClass.getState()));
        }
    }

    public ICodeInfo decompile() {
        return this.decompile(true);
    }

    public ICodeInfo getCode() {
        return this.decompile(true);
    }

    public ICodeInfo reloadCode() {
        this.add(AFlag.CLASS_DEEP_RELOAD);
        return this.decompile(false);
    }

    public void unloadCode() {
        if (this.state == ProcessState.NOT_LOADED) {
            return;
        }
        this.add(AFlag.CLASS_UNLOADED);
        this.unloadFromCache();
        this.deepUnload();
    }

    public void deepUnload() {
        if (this.clsData == null) {
            return;
        }
        this.unload();
        this.clearAttributes();
        this.root().getConstValues().removeForClass(this);
        this.initialLoad(this.clsData);
        this.innerClasses.forEach(ClassNode::deepUnload);
    }

    private void unloadFromCache() {
        if (this.isInner()) {
            return;
        }
        ICodeCache codeCache = this.root().getCodeCache();
        codeCache.remove(this.getRawName());
    }

    private synchronized ICodeInfo decompile(boolean searchInCache) {
        ICodeInfo code;
        if (this.isInner()) {
            return ICodeInfo.EMPTY;
        }
        ICodeCache codeCache = this.root().getCodeCache();
        String clsRawName = this.getRawName();
        if (searchInCache && (code = codeCache.get(clsRawName)) != null && code != ICodeInfo.EMPTY) {
            return code;
        }
        ICodeInfo codeInfo = ProcessClass.generateCode(this);
        codeCache.add(clsRawName, codeInfo);
        return codeInfo;
    }

    @Override
    public void load() {
        for (MethodNode mth : this.getMethods()) {
            try {
                mth.load();
            }
            catch (Exception e) {
                mth.addError("Method load error", e);
            }
        }
        for (ClassNode innerCls : this.getInnerClasses()) {
            innerCls.load();
        }
        this.setState(ProcessState.LOADED);
    }

    @Override
    public void unload() {
        if (this.state == ProcessState.NOT_LOADED) {
            return;
        }
        this.methods.forEach(MethodNode::unload);
        this.innerClasses.forEach(ClassNode::unload);
        this.fields.forEach(AttrNode::unloadAttributes);
        this.unloadAttributes();
        this.setState(ProcessState.NOT_LOADED);
        this.loadStage = LoadStage.NONE;
        this.smali = null;
    }

    private void buildCache() {
        this.mthInfoMap = new HashMap<MethodInfo, MethodNode>(this.methods.size());
        for (MethodNode mth : this.methods) {
            this.mthInfoMap.put(mth.getMethodInfo(), mth);
        }
    }

    @Nullable
    public ArgType getSuperClass() {
        return this.superClass;
    }

    public List<ArgType> getInterfaces() {
        return this.interfaces;
    }

    public List<ArgType> getGenericTypeParameters() {
        return this.generics;
    }

    public ArgType getType() {
        ArgType clsType = this.clsInfo.getType();
        if (Utils.notEmpty(this.generics)) {
            return ArgType.generic(clsType, this.generics);
        }
        return clsType;
    }

    public List<MethodNode> getMethods() {
        return this.methods;
    }

    public List<FieldNode> getFields() {
        return this.fields;
    }

    public void addField(FieldNode fld) {
        this.fields.add(fld);
    }

    public FieldNode getConstField(Object obj) {
        return this.getConstField(obj, true);
    }

    @Nullable
    public FieldNode getConstField(Object obj, boolean searchGlobal) {
        return this.root().getConstValues().getConstField(this, obj, searchGlobal);
    }

    @Nullable
    public FieldNode getConstFieldByLiteralArg(LiteralArg arg) {
        return this.root().getConstValues().getConstFieldByLiteralArg(this, arg);
    }

    public FieldNode searchField(FieldInfo field) {
        for (FieldNode f : this.fields) {
            if (!f.getFieldInfo().equals(field)) continue;
            return f;
        }
        return null;
    }

    public FieldNode searchFieldByNameAndType(FieldInfo field) {
        for (FieldNode f : this.fields) {
            if (!f.getFieldInfo().equalsNameAndType(field)) continue;
            return f;
        }
        return null;
    }

    public FieldNode searchFieldByName(String name) {
        for (FieldNode f : this.fields) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public FieldNode searchFieldByShortId(String shortId) {
        for (FieldNode f : this.fields) {
            if (!f.getFieldInfo().getShortId().equals(shortId)) continue;
            return f;
        }
        return null;
    }

    public MethodNode searchMethod(MethodInfo mth) {
        return this.mthInfoMap.get(mth);
    }

    public MethodNode searchMethodByShortId(String shortId) {
        for (MethodNode m : this.methods) {
            if (!m.getMethodInfo().getShortId().equals(shortId)) continue;
            return m;
        }
        return null;
    }

    @Nullable
    public MethodNode searchMethodByShortName(String name) {
        for (MethodNode m : this.methods) {
            if (!m.getMethodInfo().getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public ClassNode getParentClass() {
        return this.parentClass;
    }

    public void updateParentClass() {
        ClassNode parent;
        if (this.clsInfo.isInner() && (parent = this.root.resolveClass(this.clsInfo.getParentClass())) != null) {
            this.parentClass = parent;
            return;
        }
        this.parentClass = this;
    }

    public ClassNode getTopParentClass() {
        ClassNode parent = this.getParentClass();
        return parent == this ? this : parent.getTopParentClass();
    }

    public void visitParentClasses(Consumer<ClassNode> consumer) {
        ClassNode currentCls = this;
        ClassNode parentCls = currentCls.getParentClass();
        while (parentCls != currentCls) {
            consumer.accept(parentCls);
            currentCls = parentCls;
            parentCls = currentCls.getParentClass();
        }
    }

    public void visitSuperTypes(BiConsumer<ArgType, ArgType> consumer) {
        TypeUtils typeUtils = this.root.getTypeUtils();
        ArgType thisType = this.getType();
        if (!this.superClass.equals(ArgType.OBJECT)) {
            consumer.accept(thisType, this.superClass);
            typeUtils.visitSuperTypes(this.superClass, consumer);
        }
        for (ArgType iface : this.interfaces) {
            consumer.accept(thisType, iface);
            typeUtils.visitSuperTypes(iface, consumer);
        }
    }

    public boolean hasNotGeneratedParent() {
        if (this.contains(AFlag.DONT_GENERATE)) {
            return true;
        }
        ClassNode parent = this.getParentClass();
        if (parent == this) {
            return false;
        }
        return parent.hasNotGeneratedParent();
    }

    public List<ClassNode> getInnerClasses() {
        return this.innerClasses;
    }

    public List<ClassNode> getInlinedClasses() {
        return this.inlinedClasses;
    }

    public void getInnerAndInlinedClassesRecursive(Set<ClassNode> resultClassesSet) {
        for (ClassNode innerCls : this.innerClasses) {
            if (!resultClassesSet.add(innerCls)) continue;
            innerCls.getInnerAndInlinedClassesRecursive(resultClassesSet);
        }
        for (ClassNode inlinedCls : this.inlinedClasses) {
            if (!resultClassesSet.add(inlinedCls)) continue;
            inlinedCls.getInnerAndInlinedClassesRecursive(resultClassesSet);
        }
    }

    public void addInnerClass(ClassNode cls) {
        if (this.innerClasses.isEmpty()) {
            this.innerClasses = new ArrayList<ClassNode>(5);
        }
        this.innerClasses.add(cls);
        cls.parentClass = this;
    }

    public void addInlinedClass(ClassNode cls) {
        if (this.inlinedClasses.isEmpty()) {
            this.inlinedClasses = new ArrayList<ClassNode>(5);
        }
        this.inlinedClasses.add(cls);
    }

    public boolean isEnum() {
        return this.getAccessFlags().isEnum() && this.getSuperClass() != null && this.getSuperClass().getObject().equals(ArgType.ENUM.getObject());
    }

    public boolean isAnonymous() {
        return this.contains(AFlag.ANONYMOUS_CLASS);
    }

    public boolean isInner() {
        return this.parentClass != this;
    }

    public boolean isTopClass() {
        return this.parentClass == this;
    }

    @Nullable
    public MethodNode getClassInitMth() {
        return this.searchMethodByShortId("<clinit>()V");
    }

    @Nullable
    public MethodNode getDefaultConstructor() {
        for (MethodNode mth : this.methods) {
            if (!mth.isDefaultConstructor()) continue;
            return mth;
        }
        return null;
    }

    @Override
    public AccessInfo getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public void setAccessFlags(AccessInfo accessFlags) {
        this.accessFlags = accessFlags;
    }

    @Override
    public RootNode root() {
        return this.root;
    }

    @Override
    public String typeName() {
        return "class";
    }

    public String getRawName() {
        return this.clsInfo.getRawName();
    }

    public ClassInfo getClassInfo() {
        return this.clsInfo;
    }

    public String getShortName() {
        return this.clsInfo.getAliasShortName();
    }

    public String getFullName() {
        return this.clsInfo.getAliasFullName();
    }

    public String getPackage() {
        return this.clsInfo.getAliasPkg();
    }

    public String getDisassembledCode() {
        if (this.smali == null) {
            StringBuilder sb = new StringBuilder();
            this.getDisassembledCode(sb);
            sb.append(ICodeWriter.NL);
            LinkedHashSet<ClassNode> allInlinedClasses = new LinkedHashSet<ClassNode>();
            this.getInnerAndInlinedClassesRecursive(allInlinedClasses);
            for (ClassNode innerClass : allInlinedClasses) {
                innerClass.getDisassembledCode(sb);
                sb.append(ICodeWriter.NL);
            }
            this.smali = sb.toString();
        }
        return this.smali;
    }

    protected void getDisassembledCode(StringBuilder sb) {
        if (this.clsData == null) {
            sb.append(String.format("###### Class %s is created by jadx", this.getFullName()));
            return;
        }
        sb.append(String.format("###### Class %s (%s)", this.getFullName(), this.getRawName()));
        sb.append(ICodeWriter.NL);
        sb.append(this.clsData.getDisassembledCode());
    }

    public IClassData getClsData() {
        return this.clsData;
    }

    public ProcessState getState() {
        return this.state;
    }

    public void setState(ProcessState state) {
        this.state = state;
    }

    public LoadStage getLoadStage() {
        return this.loadStage;
    }

    public void setLoadStage(LoadStage loadStage) {
        this.loadStage = loadStage;
    }

    public void reloadAtCodegenStage() {
        ClassNode topCls = this.getTopParentClass();
        if (topCls.getLoadStage() == LoadStage.CODEGEN_STAGE) {
            throw new JadxRuntimeException("Class not yet loaded at codegen stage: " + topCls);
        }
        topCls.add(AFlag.RELOAD_AT_CODEGEN_STAGE);
    }

    public List<ClassNode> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<ClassNode> dependencies) {
        this.dependencies = dependencies;
    }

    public List<ClassNode> getCodegenDeps() {
        return this.codegenDeps;
    }

    public void setCodegenDeps(List<ClassNode> codegenDeps) {
        this.codegenDeps = codegenDeps;
    }

    public List<ClassNode> getUseIn() {
        return this.useIn;
    }

    public void setUseIn(List<ClassNode> useIn) {
        this.useIn = useIn;
    }

    public List<MethodNode> getUseInMth() {
        return this.useInMth;
    }

    public void setUseInMth(List<MethodNode> useInMth) {
        this.useInMth = useInMth;
    }

    @Override
    public String getInputFileName() {
        return this.clsData == null ? "synthetic" : this.clsData.getInputFileName();
    }

    public int hashCode() {
        return this.clsInfo.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ClassNode) {
            ClassNode other = (ClassNode)o;
            return this.clsInfo.equals(other.clsInfo);
        }
        return false;
    }

    @Override
    public int compareTo(@NotNull ClassNode o) {
        return this.getFullName().compareTo(o.getFullName());
    }

    public String toString() {
        return this.clsInfo.getFullName();
    }
}

