/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.core.dex.nodes.BlockNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class ListUtils {
    public static <T> boolean isSingleElement(@Nullable List<T> list, T obj) {
        if (list == null || list.size() != 1) {
            return false;
        }
        return Objects.equals(list.get(0), obj);
    }

    public static <T> boolean unorderedEquals(List<T> first, List<T> second) {
        if (first.size() != second.size()) {
            return false;
        }
        return first.containsAll(second);
    }

    public static <T, R> List<R> map(Collection<T> list, Function<T, R> mapFunc) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<R> result = new ArrayList<R>(list.size());
        for (T t : list) {
            result.add(mapFunc.apply(t));
        }
        return result;
    }

    public static <T> T first(List<T> list) {
        return list.get(0);
    }

    public static <T> T last(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static List<BlockNode> distinctList(List<BlockNode> list) {
        return new ArrayList<BlockNode>(new LinkedHashSet<BlockNode>(list));
    }

    public static <T> List<T> safeReplace(List<T> list, T oldObj, T newObj) {
        if (list == null || list.isEmpty()) {
            ArrayList<T> newList = new ArrayList<T>(1);
            newList.add(newObj);
            return newList;
        }
        list.remove(oldObj);
        list.add(newObj);
        return list;
    }
}

