/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.nodes.parser.SignatureParser;
import jadx.core.dex.nodes.utils.TypeUtils;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.typeinference.TypeCompareEnum;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SignatureProcessor
extends AbstractVisitor {
    private RootNode root;

    @Override
    public void init(RootNode root) {
        this.root = root;
    }

    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        this.parseClassSignature(cls);
        for (FieldNode field : cls.getFields()) {
            this.parseFieldSignature(field);
        }
        for (MethodNode mth : cls.getMethods()) {
            this.parseMethodSignature(mth);
        }
        return true;
    }

    private void parseClassSignature(ClassNode cls) {
        SignatureParser sp = SignatureParser.fromNode(cls);
        if (sp == null) {
            return;
        }
        try {
            ArgType type;
            List<ArgType> generics = sp.consumeGenericTypeParameters();
            ArgType superClass = this.validateClsType(cls, sp.consumeType(), cls.getSuperClass());
            List<ArgType> interfaces = cls.getInterfaces();
            for (int i = 0; i < interfaces.size() && (type = sp.consumeType()) != null; ++i) {
                interfaces.set(i, this.validateClsType(cls, type, interfaces.get(i)));
            }
            cls.updateGenericClsData(superClass, interfaces, generics);
        }
        catch (Exception e) {
            cls.addWarnComment("Failed to parse class signature: " + sp.getSignature(), e);
        }
    }

    private ArgType validateClsType(ClassNode cls, ArgType candidateType, ArgType currentType) {
        if (!candidateType.isObject()) {
            cls.addWarnComment("Incorrect class signature, class is not object: " + SignatureParser.getSignature(cls));
            return currentType;
        }
        if (Objects.equals(candidateType.getObject(), cls.getClassInfo().getType().getObject())) {
            cls.addWarnComment("Incorrect class signature, class is equals to this class: " + SignatureParser.getSignature(cls));
            return currentType;
        }
        return candidateType;
    }

    private void parseFieldSignature(FieldNode field) {
        SignatureParser sp = SignatureParser.fromNode(field);
        if (sp == null) {
            return;
        }
        ClassNode cls = field.getParentClass();
        try {
            ArgType gType = sp.consumeType();
            if (gType == null) {
                return;
            }
            ArgType type = this.root.getTypeUtils().expandTypeVariables(cls, gType);
            if (!this.validateParsedType(type, field.getType())) {
                cls.addWarnComment("Incorrect field signature: " + sp.getSignature());
                return;
            }
            field.updateType(type);
        }
        catch (Exception e) {
            cls.addWarnComment("Field signature parse error: " + field.getName(), e);
        }
    }

    private void parseMethodSignature(MethodNode mth) {
        SignatureParser sp = SignatureParser.fromNode(mth);
        if (sp == null) {
            return;
        }
        try {
            List<ArgType> typeParameters = sp.consumeGenericTypeParameters();
            List<ArgType> parsedArgTypes = sp.consumeMethodArgs(mth.getMethodInfo().getArgsCount());
            ArgType parsedRetType = sp.consumeType();
            mth.updateTypeParameters(typeParameters);
            TypeUtils typeUtils = this.root.getTypeUtils();
            ArgType retType = typeUtils.expandTypeVariables(mth, parsedRetType);
            List<ArgType> argTypes = Utils.collectionMap(parsedArgTypes, t -> typeUtils.expandTypeVariables(mth, (ArgType)t));
            if (!this.validateAndApplyTypes(mth, sp, retType, argTypes)) {
                mth.updateTypeParameters(Collections.emptyList());
            }
        }
        catch (Exception e) {
            mth.addWarnComment("Failed to parse method signature: " + sp.getSignature(), e);
        }
    }

    private boolean validateAndApplyTypes(MethodNode mth, SignatureParser sp, ArgType retType, List<ArgType> argTypes) {
        try {
            if (!this.validateParsedType(retType, mth.getMethodInfo().getReturnType())) {
                mth.addWarnComment("Incorrect return type in method signature: " + sp.getSignature());
                return false;
            }
            List<ArgType> checkedArgTypes = this.checkArgTypes(mth, sp, argTypes);
            if (checkedArgTypes == null) {
                return false;
            }
            mth.updateTypes(Collections.unmodifiableList(checkedArgTypes), retType);
            return true;
        }
        catch (Exception e) {
            mth.addWarnComment("Type validation failed for signature: " + sp.getSignature(), e);
            return false;
        }
    }

    private List<ArgType> checkArgTypes(MethodNode mth, SignatureParser sp, List<ArgType> parsedArgTypes) {
        MethodInfo mthInfo = mth.getMethodInfo();
        List<ArgType> mthArgTypes = mthInfo.getArgumentsTypes();
        int len = parsedArgTypes.size();
        if (len != mthArgTypes.size()) {
            if (mth.getParentClass().getAccessFlags().isEnum()) {
                return null;
            }
            if (mthInfo.isConstructor() && !mthArgTypes.isEmpty() && !parsedArgTypes.isEmpty()) {
                ArrayList<ArgType> newArgTypes = new ArrayList<ArgType>(parsedArgTypes);
                newArgTypes.add(0, mthArgTypes.get(0));
                if (newArgTypes.size() == mthArgTypes.size()) {
                    return newArgTypes;
                }
            }
            mth.addWarnComment("Incorrect args count in method signature: " + sp.getSignature());
            return null;
        }
        for (int i = 0; i < len; ++i) {
            ArgType mthArgType;
            ArgType parsedType = parsedArgTypes.get(i);
            if (this.validateParsedType(parsedType, mthArgType = mthArgTypes.get(i))) continue;
            mth.addWarnComment("Incorrect types in method signature: " + sp.getSignature());
            return null;
        }
        return parsedArgTypes;
    }

    private boolean validateParsedType(ArgType parsedType, ArgType currentType) {
        TypeCompareEnum result = this.root.getTypeCompare().compareTypes(parsedType, currentType);
        return result != TypeCompareEnum.CONFLICT;
    }
}

