/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.DeclareVariablesAttr;
import jadx.core.dex.attributes.nodes.LineAttrNode;
import jadx.core.dex.instructions.ArithNode;
import jadx.core.dex.instructions.ArithOp;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.instructions.mods.TernaryInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.InsnContainer;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.Region;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.ClassModifier;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.regions.variables.ProcessVariables;
import jadx.core.dex.visitors.shrink.CodeShrinkVisitor;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnList;
import jadx.core.utils.exceptions.JadxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

@JadxVisitor(name="PrepareForCodeGen", desc="Prepare instructions for code generation pass", runAfter={CodeShrinkVisitor.class, ClassModifier.class, ProcessVariables.class})
public class PrepareForCodeGen
extends AbstractVisitor {
    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        if (cls.root().getArgs().isDebugInfo()) {
            this.setClassSourceLine(cls);
        }
        return true;
    }

    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (mth.isNoCode()) {
            return;
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            if (block.contains(AFlag.DONT_GENERATE)) continue;
            PrepareForCodeGen.removeInstructions(block);
            PrepareForCodeGen.checkInline(block);
            PrepareForCodeGen.removeParenthesis(block);
            PrepareForCodeGen.modifyArith(block);
        }
        this.moveConstructorInConstructor(mth);
    }

    private static void removeInstructions(BlockNode block) {
        Iterator<InsnNode> it = block.getInstructions().iterator();
        while (it.hasNext()) {
            InsnNode insn = it.next();
            switch (insn.getType()) {
                case NOP: 
                case MONITOR_ENTER: 
                case MONITOR_EXIT: 
                case MOVE_EXCEPTION: {
                    it.remove();
                    break;
                }
                case CONSTRUCTOR: {
                    ConstructorInsn co = (ConstructorInsn)insn;
                    if (!co.isSelf()) break;
                    it.remove();
                    break;
                }
                case MOVE: {
                    RegisterArg result = insn.getResult();
                    if (result.getSVar().getUseCount() != 0 || !result.isNameEquals(insn.getArg(0))) break;
                    it.remove();
                    break;
                }
            }
        }
    }

    private static void checkInline(BlockNode block) {
        List<InsnNode> list = block.getInstructions();
        for (int i = 0; i < list.size(); ++i) {
            InsnNode insn = list.get(i);
            if (insn.getType() != InsnType.MOVE || !insn.getArg(0).isInsnWrap()) continue;
            InsnNode wrapInsn = ((InsnWrapArg)insn.getArg(0)).getWrapInsn();
            wrapInsn.setResult(insn.getResult());
            wrapInsn.copyAttributesFrom(insn);
            list.set(i, wrapInsn);
        }
    }

    private static void removeParenthesis(BlockNode block) {
        for (InsnNode insn : block.getInstructions()) {
            PrepareForCodeGen.removeParenthesis(insn);
        }
    }

    private static void removeParenthesis(InsnNode insn) {
        block5: {
            block4: {
                if (insn.getType() != InsnType.ARITH) break block4;
                ArithNode arith = (ArithNode)insn;
                ArithOp op = arith.getOp();
                if (op != ArithOp.ADD && op != ArithOp.MUL && op != ArithOp.AND && op != ArithOp.OR) break block5;
                for (int i = 0; i < 2; ++i) {
                    InsnArg arg = arith.getArg(i);
                    if (!arg.isInsnWrap()) continue;
                    InsnNode wrapInsn = ((InsnWrapArg)arg).getWrapInsn();
                    if (wrapInsn.getType() == InsnType.ARITH && ((ArithNode)wrapInsn).getOp() == op) {
                        wrapInsn.add(AFlag.DONT_WRAP);
                    }
                    PrepareForCodeGen.removeParenthesis(wrapInsn);
                }
                break block5;
            }
            if (insn.getType() == InsnType.TERNARY) {
                PrepareForCodeGen.removeParenthesis(((TernaryInsn)insn).getCondition());
            }
            for (InsnArg arg : insn.getArguments()) {
                if (!arg.isInsnWrap()) continue;
                InsnNode wrapInsn = ((InsnWrapArg)arg).getWrapInsn();
                PrepareForCodeGen.removeParenthesis(wrapInsn);
            }
        }
    }

    private static void removeParenthesis(IfCondition cond) {
        IfCondition.Mode mode = cond.getMode();
        for (IfCondition c : cond.getArgs()) {
            if (c.getMode() != mode) continue;
            c.add(AFlag.DONT_WRAP);
        }
    }

    private static void modifyArith(BlockNode block) {
        List<InsnNode> list = block.getInstructions();
        for (InsnNode insn : list) {
            if (insn.getType() != InsnType.ARITH || insn.contains(AFlag.ARITH_ONEARG) || insn.contains(AFlag.DECLARE_VAR)) continue;
            RegisterArg res = insn.getResult();
            InsnArg arg = insn.getArg(0);
            boolean replace = false;
            if (res.equals(arg)) {
                replace = true;
            } else if (arg.isRegister()) {
                RegisterArg regArg = (RegisterArg)arg;
                replace = res.sameCodeVar(regArg);
            }
            if (!replace) continue;
            insn.setResult(null);
            insn.add(AFlag.ARITH_ONEARG);
        }
    }

    private void moveConstructorInConstructor(MethodNode mth) {
        ConstructorInsn constrInsn;
        if (mth.isConstructor() && (constrInsn = this.searchConstructorCall(mth)) != null && !constrInsn.contains(AFlag.DONT_GENERATE)) {
            Region oldRootRegion = mth.getRegion();
            boolean firstInsn = BlockUtils.isFirstInsn(mth, constrInsn);
            DeclareVariablesAttr declVarsAttr = oldRootRegion.get(AType.DECLARE_VARIABLES);
            if (firstInsn && declVarsAttr == null) {
                return;
            }
            String callType = constrInsn.getCallType().toString().toLowerCase();
            BlockNode blockByInsn = BlockUtils.getBlockByInsn(mth, constrInsn);
            if (blockByInsn == null) {
                mth.addWarn("Failed to move " + callType + " instruction to top");
                return;
            }
            InsnList.remove(blockByInsn, (InsnNode)constrInsn);
            Region region = new Region(null);
            region.add(new InsnContainer(Collections.singletonList(constrInsn)));
            region.add(oldRootRegion);
            mth.setRegion(region);
            if (!firstInsn) {
                HashSet<RegisterArg> regArgs = new HashSet<RegisterArg>();
                constrInsn.getRegisterArgs(regArgs);
                regArgs.remove(mth.getThisArg());
                mth.getArgRegs().forEach(regArgs::remove);
                if (!regArgs.isEmpty()) {
                    mth.addWarn("Illegal instructions before constructor call");
                } else {
                    mth.addWarnComment("'" + callType + "' call moved to the top of the method (can break code semantics)");
                }
            }
        }
    }

    @Nullable
    private ConstructorInsn searchConstructorCall(MethodNode mth) {
        for (BlockNode block : mth.getBasicBlocks()) {
            for (InsnNode insn : block.getInstructions()) {
                ConstructorInsn constrInsn;
                InsnType insnType = insn.getType();
                if (insnType != InsnType.CONSTRUCTOR || !(constrInsn = (ConstructorInsn)insn).isSuper() && !constrInsn.isThis()) continue;
                return constrInsn;
            }
        }
        return null;
    }

    private void setClassSourceLine(ClassNode cls) {
        for (ClassNode innerClass : cls.getInnerClasses()) {
            this.setClassSourceLine(innerClass);
        }
        int minLine = Stream.of(cls.getMethods(), cls.getInnerClasses(), cls.getFields()).flatMap(Collection::stream).filter(mth -> !mth.contains(AFlag.DONT_GENERATE)).filter(mth -> mth.getSourceLine() != 0).mapToInt(LineAttrNode::getSourceLine).min().orElse(0);
        if (minLine != 0) {
            cls.setSourceLine(minLine - 1);
        }
    }
}

