/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.MethodOverrideAttr;
import jadx.core.dex.attributes.nodes.NotificationAttrNode;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.IMethodDetails;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.MarkMethodsForInline;
import jadx.core.dex.visitors.ModVisitor;
import jadx.core.utils.exceptions.JadxException;

@JadxVisitor(name="FixAccessModifiers", desc="Change class and method access modifiers if needed", runAfter={ModVisitor.class})
public class FixAccessModifiers
extends AbstractVisitor {
    private boolean respectAccessModifiers;

    @Override
    public void init(RootNode root) {
        this.respectAccessModifiers = root.getArgs().isRespectBytecodeAccModifiers();
    }

    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        if (this.respectAccessModifiers) {
            return true;
        }
        int newVisFlag = this.fixClassVisibility(cls);
        if (newVisFlag != -1) {
            FixAccessModifiers.changeVisibility(cls, newVisFlag);
        }
        return true;
    }

    @Override
    public void visit(MethodNode mth) {
        if (this.respectAccessModifiers || mth.contains(AFlag.DONT_GENERATE)) {
            return;
        }
        int newVisFlag = FixAccessModifiers.fixMethodVisibility(mth);
        if (newVisFlag != -1) {
            FixAccessModifiers.changeVisibility(mth, newVisFlag);
        }
    }

    public static void changeVisibility(NotificationAttrNode node, int newVisFlag) {
        AccessInfo accessFlags = node.getAccessFlags();
        AccessInfo newAccFlags = accessFlags.changeVisibility(newVisFlag);
        if (newAccFlags != accessFlags) {
            node.setAccessFlags(newAccFlags);
            node.addInfoComment("Access modifiers changed from: " + accessFlags.visibilityName());
        }
    }

    private int fixClassVisibility(ClassNode cls) {
        if (cls.getUseIn().isEmpty()) {
            return -1;
        }
        AccessInfo accessFlags = cls.getAccessFlags();
        if (accessFlags.isPrivate()) {
            if (!cls.isInner()) {
                return 1;
            }
            ClassNode topParentClass = cls.getTopParentClass();
            for (ClassNode useCls : cls.getUseIn()) {
                if (useCls.getTopParentClass() == topParentClass) continue;
                return 1;
            }
        }
        if (accessFlags.isPackagePrivate()) {
            String pkg = cls.getPackage();
            for (ClassNode useCls : cls.getUseIn()) {
                if (useCls.getPackage().equals(pkg)) continue;
                return 1;
            }
        }
        if (!accessFlags.isPublic()) {
            for (MethodNode useMth : cls.getUseInMth()) {
                boolean canInline = MarkMethodsForInline.canInline(useMth) || useMth.contains(AType.METHOD_INLINE);
                if (!canInline || useMth.getUseIn().isEmpty()) continue;
                return 1;
            }
        }
        return -1;
    }

    private static int fixMethodVisibility(MethodNode mth) {
        IMethodDetails parentMD;
        AccessInfo parentAccInfo;
        AccessInfo accessFlags = mth.getAccessFlags();
        if (accessFlags.isPublic()) {
            return -1;
        }
        MethodOverrideAttr overrideAttr = mth.get(AType.METHOD_OVERRIDE);
        if (overrideAttr != null && !overrideAttr.getOverrideList().isEmpty() && accessFlags.isVisibilityWeakerThan(parentAccInfo = new AccessInfo((parentMD = overrideAttr.getOverrideList().get(0)).getRawAccessFlags(), AccessInfo.AFType.METHOD))) {
            return parentAccInfo.getVisibility().rawValue();
        }
        if (mth.getUseIn().isEmpty()) {
            return -1;
        }
        ClassNode thisTopParentCls = mth.getParentClass().getTopParentClass();
        for (MethodNode useMth : mth.getUseIn()) {
            ClassNode useInTPCls = useMth.getParentClass().getTopParentClass();
            if (useInTPCls.equals(thisTopParentCls)) continue;
            return 1;
        }
        return -1;
    }
}

