/*
 * Decompiled with CFR 0.152.
 */
package jadx.cli;

import jadx.api.JadxArgs;
import jadx.api.security.IJadxSecurity;
import jadx.api.security.JadxSecurityFlag;
import jadx.api.security.impl.JadxSecurity;
import jadx.commons.app.JadxCommonEnv;
import jadx.zip.security.DisabledZipSecurity;
import jadx.zip.security.IJadxZipSecurity;
import jadx.zip.security.JadxZipSecurity;
import java.util.Set;

public class JadxAppCommon {
    public static void applyEnvVars(JadxArgs jadxArgs) {
        DisabledZipSecurity zipSecurity;
        boolean disableZipSecurity;
        Set flags = JadxSecurityFlag.all();
        boolean disableXmlSecurity = JadxCommonEnv.getBool((String)"JADX_DISABLE_XML_SECURITY", (boolean)false);
        if (disableXmlSecurity) {
            flags.remove(JadxSecurityFlag.SECURE_XML_PARSER);
            flags.remove(JadxSecurityFlag.VERIFY_APP_PACKAGE);
        }
        if (disableZipSecurity = JadxCommonEnv.getBool((String)"JADX_DISABLE_ZIP_SECURITY", (boolean)false)) {
            flags.remove(JadxSecurityFlag.SECURE_ZIP_READER);
            zipSecurity = DisabledZipSecurity.INSTANCE;
        } else {
            int setZipBombDetectionFactor;
            int zipBombMinUncompressedSize;
            JadxZipSecurity jadxZipSecurity = new JadxZipSecurity();
            int maxZipEntriesCount = JadxCommonEnv.getInt((String)"JADX_ZIP_MAX_ENTRIES_COUNT", (int)-2);
            if (maxZipEntriesCount != -2) {
                jadxZipSecurity.setMaxEntriesCount(maxZipEntriesCount);
            }
            if ((zipBombMinUncompressedSize = JadxCommonEnv.getInt((String)"JADX_ZIP_BOMB_MIN_UNCOMPRESSED_SIZE", (int)-2)) != -2) {
                jadxZipSecurity.setZipBombMinUncompressedSize(zipBombMinUncompressedSize);
            }
            if ((setZipBombDetectionFactor = JadxCommonEnv.getInt((String)"JADX_ZIP_BOMB_DETECTION_FACTOR", (int)-2)) != -2) {
                jadxZipSecurity.setZipBombDetectionFactor(setZipBombDetectionFactor);
            }
            zipSecurity = jadxZipSecurity;
        }
        jadxArgs.setSecurity((IJadxSecurity)new JadxSecurity(flags, (IJadxZipSecurity)zipSecurity));
    }
}

