/*
 * Decompiled with CFR 0.152.
 */
package jadx.commons.app;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class JadxTempFiles {
    private static final String JADX_TMP_INSTANCE_PREFIX = "jadx-instance-";
    private static final Path TEMP_ROOT_DIR = JadxTempFiles.createTempRootDir();

    public static Path getTempRootDir() {
        return TEMP_ROOT_DIR;
    }

    private static Path createTempRootDir() {
        try {
            Path dir;
            String jadxTmpDir = System.getenv("JADX_TMP_DIR");
            if (jadxTmpDir != null) {
                Path customTmpRootDir = Paths.get(jadxTmpDir, new String[0]);
                Files.createDirectories(customTmpRootDir, new FileAttribute[0]);
                dir = Files.createTempDirectory(customTmpRootDir, JADX_TMP_INSTANCE_PREFIX, new FileAttribute[0]);
            } else {
                dir = Files.createTempDirectory(JADX_TMP_INSTANCE_PREFIX, new FileAttribute[0]);
            }
            dir.toFile().deleteOnExit();
            return dir;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create temp root directory", e);
        }
    }
}

