/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.apks;

import jadx.api.ResourceFile;
import jadx.api.ResourcesLoader;
import jadx.api.plugins.CustomResourcesLoader;
import jadx.api.plugins.utils.CommonFileUtils;
import jadx.zip.IZipEntry;
import jadx.zip.ZipReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00072\u0006\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljadx/plugins/input/apks/ApksCustomResourcesLoader;", "Ljadx/api/plugins/CustomResourcesLoader;", "zipReader", "Ljadx/zip/ZipReader;", "<init>", "(Ljadx/zip/ZipReader;)V", "tmpFiles", "", "Ljava/io/File;", "load", "", "loader", "Ljadx/api/ResourcesLoader;", "list", "Ljadx/api/ResourceFile;", "file", "close", "", "jadx-apks-input"})
@SourceDebugExtension(value={"SMAP\nApksCustomResourcesLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApksCustomResourcesLoader.kt\njadx/plugins/input/apks/ApksCustomResourcesLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n1915#2,2:38\n*S KotlinDebug\n*F\n+ 1 ApksCustomResourcesLoader.kt\njadx/plugins/input/apks/ApksCustomResourcesLoader\n*L\n33#1:38,2\n*E\n"})
public final class ApksCustomResourcesLoader
implements CustomResourcesLoader {
    @NotNull
    private final ZipReader zipReader;
    @NotNull
    private final List<File> tmpFiles;

    public ApksCustomResourcesLoader(@NotNull ZipReader zipReader) {
        Intrinsics.checkNotNullParameter((Object)zipReader, (String)"zipReader");
        this.zipReader = zipReader;
        this.tmpFiles = new ArrayList();
    }

    public boolean load(@NotNull ResourcesLoader loader, @NotNull List<ResourceFile> list, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)string, (String)".apks", (boolean)false, (int)2, null)) {
            return false;
        }
        this.zipReader.visitEntries(file, arg_0 -> ApksCustomResourcesLoader.load$lambda$0(loader, list, this, arg_0));
        return true;
    }

    public void close() {
        Iterable $this$forEach$iv = this.tmpFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File p0 = (File)element$iv;
            boolean bl = false;
            CommonFileUtils.safeDeleteFile((File)p0);
        }
        this.tmpFiles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object load$lambda$0(ResourcesLoader $loader, List $list, ApksCustomResourcesLoader this$0, IZipEntry entry) {
        String string = entry.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string, (String)".apk", (boolean)false, (int)2, null)) {
            File file;
            Closeable closeable = entry.getInputStream();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                file = CommonFileUtils.saveToTempFile((InputStream)it, (String)".apk").toFile();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            File tmpFile = file;
            $loader.defaultLoadFile($list, tmpFile, entry.getName() + "/");
            ((Collection)this$0.tmpFiles).add(tmpFile);
        }
        return null;
    }
}

