/*
 * Decompiled with CFR 0.152.
 */
package io.github.silvaren.easyrs.tools;

import android.graphics.Bitmap;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.ScriptIntrinsicYuvToRGB;
import android.support.v8.renderscript.Type;
import android.util.Log;
import io.github.silvaren.easyrs.tools.Nv21Image;

public class YuvToRgb {
    public static Bitmap yuvToRgb(RenderScript rs, byte[] nv21ByteArray, int width, int height) {
        return YuvToRgb.yuvToRgb(rs, new Nv21Image(nv21ByteArray, width, height));
    }

    public static Bitmap yuvToRgb(RenderScript rs, Nv21Image nv21Image) {
        long startTime = System.currentTimeMillis();
        Type.Builder yuvTypeBuilder = new Type.Builder(rs, Element.U8((RenderScript)rs)).setX(nv21Image.nv21ByteArray.length);
        Type yuvType = yuvTypeBuilder.create();
        Allocation yuvAllocation = Allocation.createTyped((RenderScript)rs, (Type)yuvType, (int)1);
        yuvAllocation.copyFrom(nv21Image.nv21ByteArray);
        Type.Builder rgbTypeBuilder = new Type.Builder(rs, Element.RGBA_8888((RenderScript)rs));
        rgbTypeBuilder.setX(nv21Image.width);
        rgbTypeBuilder.setY(nv21Image.height);
        Allocation rgbAllocation = Allocation.createTyped((RenderScript)rs, (Type)rgbTypeBuilder.create());
        ScriptIntrinsicYuvToRGB yuvToRgbScript = ScriptIntrinsicYuvToRGB.create((RenderScript)rs, (Element)Element.RGBA_8888((RenderScript)rs));
        yuvToRgbScript.setInput(yuvAllocation);
        yuvToRgbScript.forEach(rgbAllocation);
        Bitmap bitmap = Bitmap.createBitmap((int)nv21Image.width, (int)nv21Image.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        rgbAllocation.copyTo(bitmap);
        Log.d((String)"NV21", (String)("Conversion to Bitmap: " + (System.currentTimeMillis() - startTime) + "ms"));
        return bitmap;
    }
}

