/*
 * Decompiled with CFR 0.152.
 */
package io.github.silvaren.easyrs.tools;

import android.graphics.Bitmap;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.ScriptIntrinsicLUT;
import io.github.silvaren.easyrs.tools.base.ConvertingTool;
import io.github.silvaren.easyrs.tools.base.RSToolboxContext;
import io.github.silvaren.easyrs.tools.params.LutParams;

public class Lut {
    private static ConvertingTool.BaseToolScript lutToolScript = new ConvertingTool.BaseToolScript<LutParams>(){

        @Override
        public void runScript(RSToolboxContext rsToolboxContext, Allocation aout, LutParams scriptParams) {
            ScriptIntrinsicLUT lutScript = ScriptIntrinsicLUT.create((RenderScript)rsToolboxContext.rs, (Element)rsToolboxContext.ain.getElement());
            scriptParams.setLutParams(lutScript);
            lutScript.forEach(rsToolboxContext.ain, aout);
        }
    };

    public static Bitmap applyLut(RenderScript rs, Bitmap inputBitmap, LutParams.RGBALut rgbaLut) {
        ConvertingTool<LutParams> lutTool = new ConvertingTool<LutParams>(lutToolScript);
        return lutTool.doComputation(rs, inputBitmap, new LutParams(rgbaLut));
    }

    public static byte[] applyLut(RenderScript rs, byte[] nv21ByteArray, int width, int height, LutParams.RGBALut rgbaLut) {
        ConvertingTool<LutParams> lutTool = new ConvertingTool<LutParams>(lutToolScript);
        return lutTool.doComputation(rs, nv21ByteArray, width, height, new LutParams(rgbaLut));
    }
}

