/*
 * Decompiled with CFR 0.152.
 */
package io.github.silvaren.easyrs.tools;

import android.graphics.Bitmap;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.ScriptIntrinsicHistogram;
import io.github.silvaren.easyrs.tools.Nv21Image;
import io.github.silvaren.easyrs.tools.base.RSToolboxContext;

public class Histogram {
    public static final int COLOR_DEPTH = 256;
    public static final int CHANNELS = 4;

    public static int[] luminanceHistogram(RenderScript rs, Bitmap inputBitmap) {
        RSToolboxContext bitmapRSContext = RSToolboxContext.createFromBitmap(rs, inputBitmap);
        Allocation aout = Allocation.createSized((RenderScript)bitmapRSContext.rs, (Element)Element.I32((RenderScript)bitmapRSContext.rs), (int)256);
        ScriptIntrinsicHistogram histogramScript = ScriptIntrinsicHistogram.create((RenderScript)bitmapRSContext.rs, (Element)bitmapRSContext.ain.getElement());
        histogramScript.setOutput(aout);
        histogramScript.forEach(bitmapRSContext.ain);
        int[] histogram = new int[256];
        aout.copyTo(histogram);
        return histogram;
    }

    public static int[] rgbaHistograms(RenderScript rs, Bitmap inputBitmap) {
        RSToolboxContext bitmapRSContext = RSToolboxContext.createFromBitmap(rs, inputBitmap);
        Allocation aout = Allocation.createSized((RenderScript)bitmapRSContext.rs, (Element)Element.I32_4((RenderScript)bitmapRSContext.rs), (int)256);
        ScriptIntrinsicHistogram histogramScript = ScriptIntrinsicHistogram.create((RenderScript)bitmapRSContext.rs, (Element)bitmapRSContext.ain.getElement());
        histogramScript.setOutput(aout);
        histogramScript.forEach(bitmapRSContext.ain);
        int[] histograms = new int[1024];
        aout.copyTo(histograms);
        return histograms;
    }

    public static int[] rgbaHistograms(RenderScript rs, byte[] nv21ByteArray, int width, int height) {
        Bitmap srcBitmap = Nv21Image.nv21ToBitmap(rs, nv21ByteArray, width, height);
        return Histogram.rgbaHistograms(rs, srcBitmap);
    }

    public static int[] luminanceHistogram(RenderScript rs, byte[] nv21ByteArray, int width, int height) {
        Bitmap srcBitmap = Nv21Image.nv21ToBitmap(rs, nv21ByteArray, width, height);
        return Histogram.luminanceHistogram(rs, srcBitmap);
    }
}

