/*
 * Decompiled with CFR 0.152.
 */
package io.github.silvaren.easyrs.tools.params;

import io.github.silvaren.easyrs.tools.params.Lut3DParams;
import io.github.silvaren.easyrs.tools.params.LutParams;

public class SampleParams {

    public static class Convolve {

        public static class Kernels3x3 {
            public static float[] SOBEL_X = new float[]{1.0f, 0.0f, -1.0f, 2.0f, 1.0f, -2.0f, 1.0f, 0.0f, -1.0f};
        }

        public static class Kernels5x5 {
            public static float[] SOBEL_X = new float[]{1.0f, 2.0f, 0.0f, -2.0f, -1.0f, 4.0f, 8.0f, 0.0f, -8.0f, -4.0f, 6.0f, 12.0f, 1.0f, -12.0f, -6.0f, 4.0f, 8.0f, 0.0f, -8.0f, -4.0f, 1.0f, 2.0f, 0.0f, -2.0f, -1.0f};
        }
    }

    public static class Lut3D {
        public static final Lut3DParams.Cube swapRedAndBlueCube() {
            int sx = 32;
            int sy = 32;
            int sz = 32;
            int[] dat = new int[32768];
            for (int z = 0; z < 32; ++z) {
                for (int y = 0; y < 32; ++y) {
                    for (int x = 0; x < 32; ++x) {
                        int v = -16777216;
                        v |= 255 * z / 31;
                        v |= 255 * y / 31 << 8;
                        dat[z * 32 * 32 + y * 32 + x] = v |= 255 * x / 31 << 16;
                    }
                }
            }
            return new Lut3DParams.Cube(32, 32, 32, dat);
        }
    }

    public static class Lut {
        public static final LutParams.RGBALut negative() {
            int[] rLut = new int[256];
            int[] gLut = new int[256];
            int[] bLut = new int[256];
            int[] aLut = new int[256];
            for (int i = 0; i < 256; ++i) {
                rLut[i] = 255 - i;
                gLut[i] = 255 - i;
                bLut[i] = 255 - i;
                aLut[i] = i;
            }
            return new LutParams.RGBALut(rLut, gLut, bLut, aLut);
        }
    }
}

