/*
 * Decompiled with CFR 0.152.
 */
package io.github.silvaren.easyrs.tools.params;

import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.Type;

public class Lut3DParams {
    public final Cube cube;

    public Lut3DParams(Cube cube) {
        this.cube = cube;
    }

    public static class Cube {
        private final int[] cube;
        private final int xSize;
        private final int ySize;
        private final int zSize;

        Cube(int xSize, int ySize, int zSize) {
            this.cube = new int[xSize * ySize * zSize];
            this.xSize = xSize;
            this.ySize = ySize;
            this.zSize = zSize;
        }

        Cube(int xSize, int ySize, int zSize, int[] cube) {
            this.cube = cube;
            this.xSize = xSize;
            this.ySize = ySize;
            this.zSize = zSize;
        }

        public int getRGBA(int x, int y, int z) {
            return this.cube[z * this.ySize * this.xSize + y * this.xSize + x];
        }

        public void setRGB(int x, int y, int z, int rgba) {
            this.cube[z * this.ySize * this.xSize + y * this.xSize + x] = rgba;
        }

        public int[] getCube() {
            return this.cube;
        }

        public Allocation createAllocation(RenderScript rs) {
            int sx = this.xSize;
            int sy = this.ySize;
            int sz = this.zSize;
            Type.Builder tb = new Type.Builder(rs, Element.U8_4((RenderScript)rs));
            tb.setX(sx);
            tb.setY(sy);
            tb.setZ(sz);
            Type t = tb.create();
            Allocation mCube = Allocation.createTyped((RenderScript)rs, (Type)t);
            mCube.copyFromUnchecked(this.getCube());
            return mCube;
        }
    }
}

