/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.web.session.tasks;

import com.logviewer.utils.Utils;
import java.io.Serializable;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class SearchPattern
implements Serializable {
    private String s;
    private boolean matchCase;
    private boolean regex;

    public SearchPattern(String s) {
        this(s, true, false);
    }

    public SearchPattern(String s, boolean matchCase, boolean regex) {
        this.s = s;
        this.matchCase = matchCase;
        this.regex = regex;
    }

    public Predicate<String> matcher() {
        if (this.regex) {
            Pattern pattern = Pattern.compile(this.s, this.matchCase ? 0 : 2);
            return str -> pattern.matcher((CharSequence)str).find();
        }
        if (this.matchCase) {
            return str -> str.contains(this.s);
        }
        return str -> Utils.containsIgnoreCase(str, this.s);
    }

    public String toString() {
        if (!this.matchCase && !this.regex) {
            return this.s;
        }
        return "<" + (this.regex ? "R" : "") + (this.matchCase ? "I" : "") + "> " + this.s;
    }
}

