/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.web.session;

import com.logviewer.data2.FileAttributes;
import com.logviewer.data2.LogView;
import com.logviewer.utils.Destroyer;
import com.logviewer.web.dto.events.EventLogChanged;
import com.logviewer.web.session.SessionAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class LogChangeNotifier
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(LogChangeNotifier.class);
    private static final long SEND_NOTIFICATION_DELAY = 700L;
    private final LogView[] logs;
    private final Destroyer[] watcherCloser;
    private final SessionAdapter sender;
    private final Timer timer;
    private Map<String, FileAttributes> changedLogs;

    public LogChangeNotifier(LogView[] logs, SessionAdapter sender, Timer timer) {
        this.logs = logs;
        this.watcherCloser = (Destroyer[])Stream.of(logs).map(log -> log.addChangeListener(attr -> this.logChanged((LogView)log, (FileAttributes)attr))).filter(Objects::nonNull).toArray(Destroyer[]::new);
        this.sender = sender;
        this.timer = timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logChanged(LogView log, @Nullable FileAttributes attr) {
        boolean scheduleTask = false;
        LogChangeNotifier logChangeNotifier = this;
        synchronized (logChangeNotifier) {
            if (this.changedLogs == null) {
                this.changedLogs = new HashMap<String, FileAttributes>();
                scheduleTask = true;
            }
            this.changedLogs.put(log.getId(), attr);
        }
        if (scheduleTask) {
            this.timer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map changedLogs;
                    LogChangeNotifier logChangeNotifier = LogChangeNotifier.this;
                    synchronized (logChangeNotifier) {
                        changedLogs = LogChangeNotifier.this.changedLogs;
                        LogChangeNotifier.this.changedLogs = null;
                    }
                    LOG.debug("Sending notification about log update: {}", changedLogs.keySet());
                    LogChangeNotifier.this.sender.send(new EventLogChanged(changedLogs));
                }
            }, 700L);
        }
    }

    @Override
    public void close() {
        if (this.watcherCloser != null) {
            for (Destroyer runnable : this.watcherCloser) {
                runnable.close();
            }
        }
    }
}

