/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.web;

import com.logviewer.api.LvFilterStorage;
import com.logviewer.api.LvPermalinkStorage;
import com.logviewer.data2.LogPath;
import com.logviewer.data2.LogRecord;
import com.logviewer.data2.LogService;
import com.logviewer.data2.LogView;
import com.logviewer.data2.Position;
import com.logviewer.data2.RecordList;
import com.logviewer.data2.net.Node;
import com.logviewer.domain.Permalink;
import com.logviewer.filters.CompositeRecordPredicate;
import com.logviewer.filters.RecordPredicate;
import com.logviewer.utils.LvGsonUtils;
import com.logviewer.utils.Pair;
import com.logviewer.utils.RuntimeInterruptedException;
import com.logviewer.web.AbstractRestRequestHandler;
import com.logviewer.web.Endpoint;
import com.logviewer.web.RestException;
import com.logviewer.web.session.LogDataListener;
import com.logviewer.web.session.LogProcess;
import com.logviewer.web.session.Status;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.text.html.FormSubmitEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class LogViewController
extends AbstractRestRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LogViewController.class);
    @Autowired
    private LvPermalinkStorage permalinkStorage;
    @Autowired
    private LvFilterStorage filterStorage;
    @Autowired
    private LogService logService;

    @Endpoint(method={FormSubmitEvent.MethodType.POST})
    public String generatePermalink(String[] hashAndPermalink) throws IOException {
        String hash = hashAndPermalink[0];
        Permalink permalink = (Permalink)LvGsonUtils.GSON.fromJson(hashAndPermalink[1], Permalink.class);
        if (permalink.getLogList() == null || permalink.getOffset() == null || permalink.getHashes() == null) {
            throw new IllegalArgumentException();
        }
        return this.permalinkStorage.save(hash, permalink);
    }

    @Endpoint(method={FormSubmitEvent.MethodType.POST})
    public void saveFilterState(String[] filterStateAndHash) {
        String hash = filterStateAndHash[0];
        String filterState = filterStateAndHash[1];
        this.filterStorage.saveFilterSet(hash, filterState);
    }

    @Endpoint(method={FormSubmitEvent.MethodType.GET, FormSubmitEvent.MethodType.POST})
    public void download(HttpServletRequest request, HttpServletResponse response) throws IOException, ExecutionException {
        LogView logView2;
        Map<String, LogView> map;
        String filtersJson = request.getParameter("filters");
        RecordPredicate[] filters = filtersJson == null || filtersJson.isEmpty() ? new RecordPredicate[]{} : (RecordPredicate[])LvGsonUtils.GSON.fromJson(filtersJson, RecordPredicate[].class);
        String[] files = request.getParameterValues("log");
        if (files == null || files.length == 0) {
            throw new RestException(400, "File list is not specified");
        }
        HashSet<LogPath> paths = new HashSet<LogPath>();
        for (String file : files) {
            paths.addAll(LogPath.parsePathFromHttpParameter(file));
        }
        if (paths.isEmpty()) {
            throw new RestException(400, "No files to download");
        }
        CompletableFuture<Map<String, LogView>> logs = this.logService.openLogs(paths);
        try {
            map = logs.get();
        }
        catch (InterruptedException e) {
            logs.cancel(true);
            throw new RuntimeInterruptedException(e);
        }
        for (LogView logView2 : map.values()) {
            if (logView2.isConnected()) continue;
            throw new RestException(407, "Failed to download log: " + logView2.getPath());
        }
        String fileName = request.getParameter("fileName");
        if (fileName == null || fileName.isEmpty()) {
            throw new RestException(400, "'fileName' parameter is not provided");
        }
        if ("on".equals(request.getParameter("zip")) || map.size() > 1) {
            if (!fileName.toLowerCase().endsWith(".zip")) {
                fileName = fileName + ".zip";
            }
            LogViewController.setDisposition(response, fileName);
            response.setContentType("application/zip");
            Map<String, LogView> nameMap = LogViewController.assignUniqueNames(map.values());
            ZipOutputStream zOut = new ZipOutputStream((OutputStream)response.getOutputStream());
            Object[] key = nameMap.keySet().toArray(new String[0]);
            Arrays.sort(key);
            for (Object name : key) {
                ZipEntry entry = new ZipEntry((String)name);
                zOut.putNextEntry(entry);
                LogView logView3 = nameMap.get(name);
                this.writeLog(logView3, zOut, filters);
            }
            zOut.close();
            return;
        }
        LogViewController.setDisposition(response, fileName);
        response.setContentType("text/plain");
        logView2 = map.values().iterator().next();
        String acceptEncoding = request.getHeader("Accept-Encoding");
        if (acceptEncoding != null && acceptEncoding.contains("gzip")) {
            response.setHeader("Content-Encoding", "gzip");
            GZIPOutputStream gzip = new GZIPOutputStream((OutputStream)response.getOutputStream());
            this.writeLog(logView2, gzip, filters);
            gzip.finish();
        } else {
            this.writeLog(logView2, (OutputStream)response.getOutputStream(), filters);
        }
    }

    private void writeLog(LogView logView, OutputStream out, @Nullable RecordPredicate[] filters) {
        final AtomicReference res = new AtomicReference();
        final CountDownLatch cnt = new CountDownLatch(1);
        final OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        Position start = new Position(logView.getId(), 0L, 0L);
        LogProcess logProcess = logView.loadRecords(CompositeRecordPredicate.and(filters), Integer.MAX_VALUE, start, false, null, Long.MAX_VALUE, new LogDataListener(){

            @Override
            public void onData(@NonNull RecordList data) {
                if (cnt.getCount() == 0L) {
                    return;
                }
                try {
                    for (Pair pair : data) {
                        writer.append(((LogRecord)pair.getFirst()).getMessage()).append('\n');
                    }
                }
                catch (IOException e) {
                    res.set(new Status(e));
                    cnt.countDown();
                }
            }

            @Override
            public void onFinish(@NonNull Status status, boolean eof) {
                if (cnt.getCount() == 0L) {
                    return;
                }
                res.set(status);
                cnt.countDown();
            }
        });
        logProcess.start();
        try {
            cnt.await();
        }
        catch (InterruptedException e) {
            logProcess.cancel();
            throw new RuntimeInterruptedException(e);
        }
        if (((Status)res.get()).getError() != null) {
            logProcess.cancel();
            LOG.error("Failed to download log", ((Status)res.get()).getError());
            throw new RestException(500, "Failed to download log: " + ((Status)res.get()).getError());
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static Map<String, LogView> assignUniqueNames(Collection<LogView> logs) {
        HashMap<String, Set> shortName2path = new HashMap<String, Set>();
        for (LogView logView : logs) {
            String string = logView.getPath().getFile();
            Path path2 = Paths.get(string, new String[0]);
            Set paths = shortName2path.computeIfAbsent(path2.getFileName().toString(), key -> new HashSet());
            paths.add(string);
        }
        HashMap path2file = new HashMap();
        for (Map.Entry entry : shortName2path.entrySet()) {
            Object path32;
            Set paths = (Set)entry.getValue();
            if (paths.size() == 1) {
                path2file.put(paths.iterator().next(), entry.getKey());
                continue;
            }
            String prefix = null;
            for (Object path32 : paths) {
                if (prefix == null) {
                    prefix = path32;
                    continue;
                }
                prefix = LogViewController.commonPrefix(prefix, (String)path32);
            }
            assert (prefix != null);
            int slashIdx = prefix.lastIndexOf(47);
            path32 = paths.iterator();
            while (path32.hasNext()) {
                String path4 = (String)path32.next();
                path2file.put(path4, path4.substring(slashIdx + 1));
            }
        }
        boolean bl = logs.stream().map(l -> l.getPath().getNode()).distinct().count() > 1L;
        boolean bl2 = bl && logs.stream().filter(l -> l.getPath().getNode() != null).map(l -> {
            Integer port = l.getPath().getNode().getPort();
            return port == null ? 9595 : port;
        }).distinct().count() > 1L;
        HashMap<String, LogView> res = new HashMap<String, LogView>();
        for (LogView log : logs) {
            LogPath path = log.getPath();
            String fileName = ((String)path2file.get(path.getFile())).replaceAll("[\\\\/*?:&|>]", "_");
            Node node = path.getNode();
            if (node != null && bl) {
                fileName = bl2 && node.getPort() != null ? node.getHost() + '-' + node.getPort() + "_" + fileName : node.getHost() + "_" + fileName;
            }
            if (res.containsKey(fileName)) {
                fileName = fileName.toLowerCase().endsWith(".log") ? fileName.substring(0, fileName.length() - ".log".length()) + "." + log.getId() + ".log" : fileName + '-' + log.getId();
            }
            res.put(fileName, log);
        }
        return res;
    }

    private static String commonPrefix(@NonNull String a, @NonNull String b) {
        int max = Math.min(a.length(), b.length());
        for (int i = 0; i < max; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return a.substring(0, i);
        }
        return a.length() < b.length() ? a : b;
    }

    private static void setDisposition(HttpServletResponse response, String fileName) throws UnsupportedEncodingException {
        String headerVal = String.format("attachment;filename=\"%s\";filename*=UTF-8''%s", fileName, URLEncoder.encode(fileName, "UTF-8"));
        response.setHeader("Content-Disposition", headerVal);
    }
}

