/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.web;

import com.logviewer.api.LvFileAccessManager;
import com.logviewer.api.LvFileNavigationManager;
import com.logviewer.data2.FavoriteLogService;
import com.logviewer.files.FileType;
import com.logviewer.files.FileTypes;
import com.logviewer.utils.Utils;
import com.logviewer.web.AbstractRestRequestHandler;
import com.logviewer.web.Endpoint;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.text.html.FormSubmitEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class LogNavigatorController
extends AbstractRestRequestHandler {
    private static final String DIR_ICON = "assets/dir.png";
    public static final String CFG_FS_NAVIGATION_ENABLED = "log-viewer.fs-navigation.enabled";
    @Autowired
    private FavoriteLogService favoriteLogService;
    @Autowired
    private LvFileNavigationManager fileManager;
    @Autowired
    private LvFileAccessManager fileAccessManager;
    @Autowired
    private Environment environment;
    private Pattern logFilePattern;
    private volatile boolean logFilePatternInited;

    @Endpoint
    public RestInitState initState() {
        RestInitState res = new RestInitState();
        res.favoritesEditable = this.favoriteLogService.isEditable();
        res.favorites = this.getRestFavorites(this.favoriteLogService.getFavorites());
        res.showFileTree = this.isFileTreeAllowed();
        if (res.showFileTree) {
            Path defaultDirectoryFromConfig = this.fileManager.getDefaultDirectory();
            res.defaultDir = defaultDirectoryFromConfig == null ? null : defaultDirectoryFromConfig.toString();
            String initialDir = this.getRequest().getParameter("initialDir");
            Path initDir = StringUtils.isEmpty((Object)initialDir) ? defaultDirectoryFromConfig : Paths.get(initialDir, new String[0]);
            res.initDir = initDir == null ? null : initDir.toString();
            res.initDirContent = this.getDirContent(initDir);
        }
        return res;
    }

    private boolean isFileTreeAllowed() {
        return (Boolean)this.environment.getProperty(CFG_FS_NAVIGATION_ENABLED, Boolean.class, (Object)true);
    }

    RestContent getDirContent(@Nullable Path dir) {
        if (!this.isFileTreeAllowed()) {
            return new RestContent("File system navigation is disabled");
        }
        try {
            List<LvFileNavigationManager.LvFsItem> items = this.fileManager.getChildren(dir);
            return new RestContent(this.createFileItems(items));
        }
        catch (SecurityException e) {
            return new RestContent(e.getMessage());
        }
        catch (IOException e) {
            return new RestContent("Failed to load file list: " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    private boolean isLog(Path path) {
        if (!this.logFilePatternInited) {
            String logFilePattern = this.environment.getProperty("log-viewer.navigation.log-file-pattern");
            if (!StringUtils.isEmpty((Object)logFilePattern)) {
                this.logFilePattern = Pattern.compile(logFilePattern);
            }
            this.logFilePatternInited = true;
        }
        return this.logFilePattern != null && this.logFilePattern.matcher(path.toString()).matches();
    }

    private List<FsItem> createFileItems(List<LvFileNavigationManager.LvFsItem> files) {
        ArrayList<FsItem> res = new ArrayList<FsItem>(files.size());
        for (LvFileNavigationManager.LvFsItem file : files) {
            if (file.isDirectory()) {
                res.add(new DirItem(file.getPath(), DIR_ICON));
                continue;
            }
            FileType fileType = this.isLog(file.getPath()) ? FileTypes.LOG : FileTypes.detectType(file.getPath().toString());
            res.add(new FileItem(file.getPath(), fileType, file.getSize(), file.getModificationTime()));
        }
        List<String> favorites = this.favoriteLogService.getFavorites();
        for (FsItem item : res) {
            if (!favorites.contains(item.path)) continue;
            item.attr.put("favorite", true);
        }
        res.sort(Comparator.naturalOrder());
        return res;
    }

    @Endpoint
    public RestContent listDir() {
        String dir = this.getRequest().getParameter("dir");
        return this.getDirContent(Paths.get(dir, new String[0]));
    }

    @Endpoint
    public RestOpenPathResponse openCustomDir() {
        String dir = this.getRequest().getParameter("dir");
        if (!this.isFileTreeAllowed()) {
            return new RestOpenPathResponse("File system navigation is disabled");
        }
        Path path = Paths.get(dir, new String[0]);
        if (!path.isAbsolute()) {
            return new RestOpenPathResponse("Path is not absolute");
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return new RestOpenPathResponse(this.getDirContent(path), null, dir);
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            if (!this.fileAccessManager.isFileVisible(path)) {
                return new RestOpenPathResponse(this.fileAccessManager.errorMessage(path));
            }
            return new RestOpenPathResponse(this.getDirContent(path.getParent()), path.toString(), path.getParent().toString());
        }
        if (!this.fileAccessManager.isDirectoryVisible(path)) {
            return new RestOpenPathResponse(this.fileAccessManager.errorMessage(path));
        }
        return new RestOpenPathResponse("Directory not found");
    }

    @Endpoint(method={FormSubmitEvent.MethodType.POST})
    public List<RestFileState> addFavoriteLog(String path) {
        List<String> favorites = this.favoriteLogService.addFavoriteLog(path);
        return this.getRestFavorites(favorites);
    }

    @Endpoint(method={FormSubmitEvent.MethodType.POST})
    public List<RestFileState> removeFavoriteLog(String path) {
        List<String> favorites = this.favoriteLogService.removeFavorite(path);
        return this.getRestFavorites(favorites);
    }

    private List<RestFileState> getRestFavorites(List<String> src) {
        ArrayList<RestFileState> res = new ArrayList<RestFileState>(src.size());
        for (String logPath : src) {
            RestFileState log = new RestFileState();
            log.path = logPath;
            Path path = Paths.get(logPath, new String[0]);
            try {
                BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                if (attrs.isRegularFile()) {
                    log.lastModification = attrs.lastModifiedTime().toMillis();
                    log.size = attrs.size();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            res.add(log);
        }
        return res;
    }

    static class FileItem
    extends FsItem {
        final String type;
        private final long size;
        private final Long modificationTime;

        public FileItem(Path path, FileType type, long size, @Nullable Long modificationTime) {
            super(path, type.getIcon(), false);
            this.type = type.getTypeId();
            this.size = size;
            this.modificationTime = modificationTime;
        }
    }

    private static class DirItem
    extends FsItem {
        private List<?> singleItem;

        public DirItem(Path path, String icon) {
            super(path, icon, true);
        }
    }

    static abstract class FsItem
    implements Comparable<FsItem> {
        protected final String path;
        protected final String name;
        protected final String icon;
        protected final boolean isDirectory;
        protected final Map<String, Object> attr = new HashMap<String, Object>();

        FsItem(Path path, String icon, boolean isDirectory) {
            Path fileName;
            this.path = path.toString();
            this.name = path.toString().equals("/") ? "/" : ((fileName = path.getFileName()) == null ? "" : fileName.toString());
            this.icon = icon;
            this.isDirectory = isDirectory;
        }

        @Override
        public int compareTo(@NonNull FsItem o) {
            if (this.isDirectory != o.isDirectory) {
                return this.isDirectory ? -1 : 1;
            }
            return Utils.compareFileNames(this.name, o.name);
        }
    }

    private static class RestOpenPathResponse {
        private RestContent content;
        private String selectedPath;
        private String newCurrentDir;

        public RestOpenPathResponse(String error) {
            this(new RestContent(error), null, null);
        }

        public RestOpenPathResponse(RestContent content, String selectedPath, String newCurrentDir) {
            this.content = content;
            this.selectedPath = selectedPath;
            this.newCurrentDir = newCurrentDir;
        }
    }

    static class RestContent {
        String error;
        List<FsItem> content;

        public RestContent(String error) {
            this.error = error;
        }

        public RestContent(List<FsItem> content) {
            this.content = content;
        }
    }

    public static class RestFileState {
        private String path;
        private Long size;
        private Long lastModification;
    }

    public static class RestInitState {
        private List<RestFileState> favorites;
        private boolean favoritesEditable;
        private boolean showFileTree;
        private String initDir;
        private String defaultDir;
        private RestContent initDirContent;
    }
}

