/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.web;

import com.logviewer.utils.LvGsonUtils;
import com.logviewer.web.Endpoint;
import com.logviewer.web.RestException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.text.html.FormSubmitEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.StreamUtils;

public abstract class AbstractRestRequestHandler
implements AutoCloseable {
    private final ThreadLocal<HttpServletRequest> request = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger(AbstractRestRequestHandler.class);
    private final Map<String, Method> methods = new HashMap<String, Method>();

    protected AbstractRestRequestHandler() {
        for (Method method : this.getClass().getMethods()) {
            Endpoint getAnn = method.getAnnotation(Endpoint.class);
            if (getAnn == null) continue;
            Method oldMethod = this.methods.put(method.getName(), method);
            assert (oldMethod == null) : method.getName();
        }
    }

    @NonNull
    protected HttpServletRequest getRequest() {
        return this.request.get();
    }

    protected Long getLongParam(String name) {
        String paramStr = this.getRequest().getParameter(name);
        if (paramStr == null) {
            return null;
        }
        return Long.parseLong(paramStr);
    }

    protected int getIntParam(String name) {
        return Integer.parseInt(this.getRequest().getParameter(name));
    }

    protected int getIntParam(String name, int defVal) {
        String s = this.getRequest().getParameter(name);
        if (s == null) {
            return defVal;
        }
        return Integer.parseInt(s);
    }

    private static void validateMethodType(HttpServletRequest req, FormSubmitEvent.MethodType[] method) {
        try {
            FormSubmitEvent.MethodType methodType = FormSubmitEvent.MethodType.valueOf(req.getMethod());
            if (Arrays.asList(method).contains((Object)methodType)) {
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw new RestException(405, "Wrong method: " + req.getMethod());
    }

    private Object loadBody(Class<?> type, HttpServletRequest req) throws IOException {
        String str = StreamUtils.copyToString((InputStream)req.getInputStream(), (Charset)StandardCharsets.UTF_8);
        if (type == String.class) {
            return str;
        }
        if (str.isEmpty()) {
            return null;
        }
        return LvGsonUtils.GSON.fromJson(str, type);
    }

    /*
     * Exception decompiling
     */
    public final void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void sendResponse(HttpServletResponse resp, int code, String message) throws IOException {
        if (resp.isCommitted()) {
            throw new IllegalStateException("Response already committed");
        }
        resp.reset();
        resp.setContentType("text/plain");
        resp.setCharacterEncoding("UTF-8");
        resp.setStatus(code);
        resp.getWriter().append(message);
    }

    @Override
    public void close() {
    }
}

