/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.utils;

import com.logviewer.data2.net.server.Message;
import com.logviewer.utils.OpenByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;

public class MessageReader {
    public static final int MAX_MESSAGE_SIZE = 0x500000;
    private final ByteBuffer countBuffer = ByteBuffer.allocate(4);
    private ByteBuffer buffer;
    private boolean readingCount = true;

    public ByteBuffer getCurrentBuffer() {
        return this.readingCount ? this.countBuffer : this.buffer;
    }

    public Object onReceive() throws IOException, ClassNotFoundException {
        Object res;
        if (this.readingCount) {
            if (this.countBuffer.position() < 4) {
                return null;
            }
            int packageSize = this.countBuffer.getInt(0);
            if (packageSize > 0x500000) {
                throw new IOException("Message too big: " + packageSize);
            }
            this.readingCount = false;
            this.buffer = ByteBuffer.allocate(packageSize);
            return null;
        }
        if (this.buffer.hasRemaining()) {
            return null;
        }
        try (ObjectInputStream oIn = new ObjectInputStream(new ByteArrayInputStream(this.buffer.array()));){
            res = oIn.readObject();
        }
        this.readingCount = true;
        this.buffer = null;
        this.countBuffer.position(0);
        return res;
    }

    public static void serializeMessages(OpenByteArrayOutputStream bOut, Message message) throws IOException {
        int start = bOut.size();
        bOut.write(0);
        bOut.write(0);
        bOut.write(0);
        bOut.write(0);
        try (ObjectOutputStream objOut = new ObjectOutputStream(bOut);){
            objOut.writeObject(message);
        }
        int messageSize = bOut.size() - 4 - start;
        if (messageSize > 0x500000) {
            throw new IllegalArgumentException("Message too big: " + messageSize);
        }
        ByteBuffer.wrap(bOut.getBuffer(), 0, bOut.size()).putInt(start, messageSize);
    }
}

