/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.formats.utils;

import com.logviewer.formats.utils.LvLayoutCustomTypeNode;
import com.logviewer.formats.utils.LvLayoutNodeSearchable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class LvLayoutRegexNode
extends LvLayoutCustomTypeNode
implements LvLayoutNodeSearchable {
    private final Pattern pattern;
    private Matcher matcher;

    public LvLayoutRegexNode(@NonNull String fieldName, @Nullable String fieldType, String pattern) {
        this(fieldName, fieldType, Pattern.compile(pattern));
    }

    public LvLayoutRegexNode(@NonNull String fieldName, @Nullable String fieldType, Pattern pattern) {
        super(fieldName, fieldType);
        this.pattern = pattern;
    }

    private Matcher getMatcher(String s) {
        if (this.matcher == null) {
            this.matcher = this.pattern.matcher(s);
        } else {
            this.matcher.reset(s);
        }
        return this.matcher;
    }

    @Override
    public int parse(String s, int offset, int end) {
        Matcher matcher = this.getMatcher(s);
        matcher.region(offset, end);
        if (matcher.lookingAt()) {
            return matcher.end();
        }
        return -2147483647;
    }

    @Override
    public int search(String s, int offset, int end) {
        Matcher matcher = this.getMatcher(s);
        matcher.region(offset, end);
        if (matcher.find()) {
            return matcher.start();
        }
        return -2147483647;
    }

    @Override
    public LvLayoutRegexNode clone() {
        return new LvLayoutRegexNode(this.getFieldName(), this.getFieldType(), this.pattern);
    }
}

