/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.filters;

import com.google.gson.annotations.JsonAdapter;
import com.logviewer.data2.LogFilterContext;
import com.logviewer.data2.LogRecord;
import com.logviewer.filters.RecordPredicate;
import com.logviewer.utils.GsonNanosecondsAdapter;
import com.logviewer.utils.LvDateUtils;
import java.util.Date;

public class DatePredicate
implements RecordPredicate {
    private Long date;
    @JsonAdapter(value=GsonNanosecondsAdapter.class)
    private Long timestamp;
    private boolean greater;

    public DatePredicate() {
    }

    public DatePredicate(Date date, boolean greater) {
        this(LvDateUtils.toNanos(date.getTime()), greater);
    }

    public DatePredicate(long timestamp, boolean greater) {
        this.timestamp = timestamp;
        this.greater = greater;
    }

    @Override
    public boolean test(LogRecord record, LogFilterContext ctx) {
        if (!record.hasTime()) {
            return true;
        }
        long ts = this.getDate();
        if (ts == 0L) {
            return true;
        }
        if (this.greater) {
            return record.getTime() >= ts;
        }
        return record.getTime() <= ts;
    }

    public long getDate() {
        if (this.timestamp != null) {
            return this.timestamp;
        }
        return this.date == null ? 0L : LvDateUtils.toNanos(this.date);
    }

    public DatePredicate setDate(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public boolean isGreater() {
        return this.greater;
    }

    public DatePredicate setGreater(boolean greater) {
        this.greater = greater;
        return this;
    }
}

