/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2.net.server;

import com.logviewer.data2.Log;
import com.logviewer.data2.LogFormat;
import com.logviewer.data2.net.server.api.RemoteTask;
import com.logviewer.data2.net.server.api.RemoteTaskContext;
import com.logviewer.utils.LvGsonUtils;
import java.util.concurrent.CompletableFuture;
import org.springframework.lang.NonNull;

public class TryReadTask
implements RemoteTask<Void> {
    private final String file;
    private final String format;

    public TryReadTask(@NonNull String file, String format) {
        this.file = file;
        this.format = format;
    }

    @Override
    public void start(@NonNull RemoteTaskContext<Void> ctx) {
        Log log = ctx.getLogService().openLog(this.file, (LogFormat)LvGsonUtils.GSON.fromJson(this.format, LogFormat.class));
        CompletableFuture<Throwable> future = log.tryRead();
        future.whenComplete((res, error) -> {
            if (res != null) {
                ctx.sendErrorAndCloseChannel((Throwable)res);
            } else if (error != null) {
                ctx.sendErrorAndCloseChannel((Throwable)error);
            } else {
                ctx.sendAndCloseChannel(null);
            }
        });
    }

    @Override
    public void cancel() {
    }
}

