/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2.net.server;

import com.logviewer.data2.FileAttributes;
import com.logviewer.data2.net.server.api.RemoteTask;
import com.logviewer.data2.net.server.api.RemoteTaskContext;
import com.logviewer.utils.Destroyer;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class LogWatcherTask
implements RemoteTask<FileAttributes> {
    private static final Logger LOG = LoggerFactory.getLogger(LogWatcherTask.class);
    public static final long DELAY = 200L;
    private final String path;
    private Destroyer closeable;

    public LogWatcherTask(String path) {
        this.path = path;
    }

    @Override
    public void start(@NonNull RemoteTaskContext<FileAttributes> ctx) {
        Path path = Paths.get(this.path, new String[0]).toAbsolutePath();
        try {
            this.closeable = ctx.getLogService().getFileWatcherService().watchDirectory(path.getParent(), changedDirs -> {
                if (changedDirs.contains(path)) {
                    ctx.getLogService().getTimer().scheduleTask(this, () -> {
                        FileAttributes attr;
                        try {
                            attr = FileAttributes.fromPath(path);
                        }
                        catch (IOException e) {
                            LOG.error("Failed to read file attributes", (Throwable)e);
                            return;
                        }
                        ctx.send(attr);
                    }, 200L);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void cancel() {
        if (this.closeable != null) {
            this.closeable.close();
        }
    }
}

