/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2.net;

import com.logviewer.data2.net.Node;
import com.logviewer.data2.net.OutcomeConnection;
import com.logviewer.data2.net.server.api.RemoteTask;
import com.logviewer.data2.net.server.api.RemoteTaskController;
import com.logviewer.utils.RuntimeInterruptedException;
import com.logviewer.utils.Utils;
import com.logviewer.utils.Wrappers;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.lang.NonNull;

public class RemoteNodeService
implements DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteNodeService.class);
    private final Map<Node, CompletableFuture<OutcomeConnection>> connections = new HashMap<Node, CompletableFuture<OutcomeConnection>>();
    private boolean closed;

    public synchronized CompletableFuture<OutcomeConnection> getNodeConnection(final @NonNull Node node) {
        if (this.closed) {
            throw new IllegalStateException("Server is closed");
        }
        while (true) {
            CompletableFuture<OutcomeConnection> future;
            if ((future = this.connections.get(node)) != null) {
                OutcomeConnection res;
                if (!future.isDone()) {
                    return future;
                }
                try {
                    res = future.get();
                }
                catch (InterruptedException e) {
                    throw new RuntimeInterruptedException(e);
                }
                catch (ExecutionException e) {
                    throw Utils.propagate(e.getCause());
                }
                if (res.isOpen()) {
                    return future;
                }
            }
            CompletableFuture<OutcomeConnection> newFuture = new CompletableFuture<OutcomeConnection>();
            if (future == null ? this.connections.putIfAbsent(node, newFuture) != null : !this.connections.replace(node, future, newFuture)) continue;
            try {
                final AsynchronousSocketChannel socket = AsynchronousSocketChannel.open();
                int port = node.getPort() == null ? 9595 : node.getPort();
                socket.connect(new InetSocketAddress(node.getHost(), port), newFuture, new CompletionHandler<Void, CompletableFuture<OutcomeConnection>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void completed(Void result, CompletableFuture<OutcomeConnection> newFuture) {
                        RemoteNodeService remoteNodeService = RemoteNodeService.this;
                        synchronized (remoteNodeService) {
                            if (RemoteNodeService.this.closed) {
                                Utils.closeQuietly(socket);
                            } else {
                                OutcomeConnection connection = new OutcomeConnection(node, socket);
                                connection.init();
                                newFuture.complete(connection);
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void failed(Throwable exc, CompletableFuture<OutcomeConnection> newFuture) {
                        RemoteNodeService remoteNodeService = RemoteNodeService.this;
                        synchronized (remoteNodeService) {
                            if (!RemoteNodeService.this.closed) {
                                RemoteNodeService.this.connections.remove(node, newFuture);
                                newFuture.completeExceptionally(exc);
                            }
                        }
                    }
                });
            }
            catch (Throwable e) {
                assert (this.connections.get(node) == newFuture);
                this.connections.remove(node, newFuture);
                newFuture.completeExceptionally(e);
                return newFuture;
            }
        }
    }

    public <E, T extends RemoteTask<E>> RemoteTaskController<T> startTask(@NonNull Node node, @NonNull T task, @NonNull BiConsumer<E, Throwable> callback) {
        RemoteTaskControllerImpl controller = new RemoteTaskControllerImpl(this, node, task, callback);
        controller.start();
        return controller;
    }

    public <E, T extends RemoteTask<E>> RemoteTaskController<T> createTask(@NonNull Node node, @NonNull T task, @NonNull BiConsumer<E, Throwable> callback) {
        return new RemoteTaskControllerImpl(this, node, task, callback);
    }

    public void startTask(RemoteTaskController<?> notStartedTask) {
        ((RemoteTaskControllerImpl)notStartedTask).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        RemoteNodeService remoteNodeService = this;
        synchronized (remoteNodeService) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        for (CompletableFuture completableFuture : this.connections.values()) {
            if (completableFuture.isDone()) {
                try {
                    ((OutcomeConnection)completableFuture.get()).close();
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            completableFuture.completeExceptionally(new IOException(this.getClass().getSimpleName() + " server closed"));
        }
    }

    private static class RemoteTaskControllerImpl<E, T extends RemoteTask<E>>
    implements RemoteTaskController<T> {
        private Node node;
        private T task;
        private final BiConsumer<E, Throwable> callback;
        private RemoteTaskController<T> controller;
        private boolean canceled;
        final /* synthetic */ RemoteNodeService this$0;

        RemoteTaskControllerImpl(@NonNull Node node, @NonNull T task, BiConsumer<E, Throwable> callback) {
            this.this$0 = var1_1;
            this.node = node;
            this.task = task;
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Node node;
            RemoteTaskControllerImpl remoteTaskControllerImpl = this;
            synchronized (remoteTaskControllerImpl) {
                if (this.node == null) {
                    throw new IllegalStateException("Task already started");
                }
                node = this.node;
                this.node = null;
            }
            this.this$0.getNodeConnection(node).whenComplete((BiConsumer)Wrappers.of(LOG, (conn, e) -> {
                if (e != null) {
                    this.callback.accept((E)null, (Throwable)e);
                } else {
                    RemoteTaskControllerImpl remoteTaskControllerImpl = this;
                    synchronized (remoteTaskControllerImpl) {
                        if (this.canceled) {
                            return;
                        }
                        RemoteTaskController<T> c = conn.startTask(this.task, this.callback);
                        assert (this.controller == null);
                        this.controller = c;
                        this.task = null;
                    }
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void alterTask(Consumer<T> modifier) {
            RemoteTaskControllerImpl remoteTaskControllerImpl = this;
            synchronized (remoteTaskControllerImpl) {
                if (this.controller == null) {
                    assert (this.task != null);
                    modifier.accept(this.task);
                    return;
                }
            }
            this.controller.alterTask(modifier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            RemoteTaskControllerImpl remoteTaskControllerImpl = this;
            synchronized (remoteTaskControllerImpl) {
                if (this.controller == null) {
                    this.canceled = true;
                    return;
                }
            }
            this.controller.cancel();
        }
    }
}

