/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2.config;

import com.logviewer.utils.Utils;
import java.util.regex.Pattern;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class VisibleDirectory {
    private final String directory;
    private final String fileRegex;
    private volatile transient Pattern pattern;

    public VisibleDirectory(@NonNull String directory) {
        this(directory, null);
    }

    public VisibleDirectory(@NonNull String directory, @Nullable String fileRegex) {
        this.directory = directory;
        this.fileRegex = StringUtils.isEmpty((Object)fileRegex) ? null : fileRegex;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFileRegex() {
        return this.fileRegex;
    }

    public boolean match(@NonNull String path) {
        if (!Utils.isSubdirectory(this.directory, path)) {
            return false;
        }
        if (this.fileRegex == null) {
            return true;
        }
        String relativePath = path.substring(this.directory.length());
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        if (relativePath.isEmpty()) {
            return true;
        }
        Pattern pattern = this.pattern;
        if (pattern == null) {
            this.pattern = pattern = Pattern.compile(this.fileRegex);
        }
        return pattern.matcher(relativePath).matches();
    }

    public String toString() {
        if (this.fileRegex == null) {
            return this.directory;
        }
        return this.directory + " [~" + this.fileRegex + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VisibleDirectory that = (VisibleDirectory)o;
        return this.directory.equals(that.directory) && (this.fileRegex != null ? this.fileRegex.equals(that.fileRegex) : that.fileRegex == null);
    }

    public int hashCode() {
        int result = this.directory.hashCode();
        result = 31 * result + (this.fileRegex != null ? this.fileRegex.hashCode() : 0);
        return result;
    }
}

