/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2;

import com.logviewer.data2.LogFilterContext;
import com.logviewer.data2.LogFormat;
import com.logviewer.data2.LogRecord;
import com.logviewer.data2.LogView;
import com.logviewer.filters.RecordPredicate;
import com.logviewer.utils.Pair;
import com.logviewer.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class LvPredicateChecker
implements LogFilterContext,
AutoCloseable {
    private final LogView logView;
    private final LogFormat logFormat;
    private final String logId;
    private Map<String, Object> context;

    public LvPredicateChecker(LogView logView) {
        this.logView = logView;
        this.logFormat = logView.getFormat();
        this.logId = logView.getId();
    }

    @Override
    public LogFormat getLogFormat() {
        return this.logFormat;
    }

    @Override
    @NonNull
    public LogFormat.FieldDescriptor[] getFields() {
        return this.logFormat.getFields();
    }

    @Override
    @NonNull
    public <T> T getProperty(String name, Function<String, T> factory) {
        if (this.context == null) {
            this.context = new HashMap<String, Object>();
        }
        return (T)this.context.computeIfAbsent(name, factory);
    }

    public Pair<LogRecord, Throwable> applyFilter(@NonNull LogRecord record, @Nullable RecordPredicate filter) {
        try {
            if (filter != null && !filter.test(record, this)) {
                return null;
            }
        }
        catch (Throwable e) {
            return new Pair<LogRecord, Throwable>(record, e);
        }
        return new Pair<LogRecord, Object>(record, null);
    }

    @Override
    public void close() throws Exception {
        if (this.context != null) {
            for (Object value : this.context.values()) {
                if (!(value instanceof AutoCloseable)) continue;
                Utils.closeQuietly((AutoCloseable)value);
            }
        }
    }
}

