/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2;

import com.logviewer.utils.TextRange;
import com.logviewer.utils.Utils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.NonNull;

public class LogRecord
implements Comparable<LogRecord>,
Externalizable {
    public static final String WHOLE_LINE = "_";
    private String logId;
    private String message;
    private long timeNanos;
    private Map<String, Integer> fieldNames;
    private int[] fieldPositions;
    private long start;
    private long end;
    private int loadedTextLengthBytes;

    public LogRecord() {
    }

    public LogRecord(@NonNull String message, long timeNanos, long start, long end, int loadedTextLengthBytes) {
        this(message, timeNanos, start, end, loadedTextLengthBytes, Utils.EMPTY_INT_ARRAY, Collections.emptyMap());
    }

    public LogRecord(@NonNull String message, long timeNanos, long start, long end, int loadedTextLengthBytes, @NonNull int[] fieldPositions, @NonNull Map<String, Integer> fieldNames) {
        assert (fieldPositions.length == fieldNames.size() * 2);
        Utils.assertValidTimestamp(timeNanos);
        this.message = message;
        this.timeNanos = timeNanos;
        this.start = start;
        this.end = end;
        this.loadedTextLengthBytes = loadedTextLengthBytes;
        this.fieldPositions = fieldPositions;
        this.fieldNames = fieldNames;
    }

    public String getLogId() {
        return this.logId;
    }

    public LogRecord setLogId(String logId) {
        this.logId = logId;
        return this;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public boolean hasMore() {
        return (long)this.loadedTextLengthBytes < this.end - this.start;
    }

    public int getLoadedTextLengthBytes() {
        return this.loadedTextLengthBytes;
    }

    public long getTime() {
        return this.timeNanos;
    }

    public long getTimeMillis() {
        return this.timeNanos / 1000000L;
    }

    public boolean hasTime() {
        return this.timeNanos > 0L;
    }

    public String getMessage() {
        return this.message;
    }

    public TextRange getFieldOffset(String fieldName) {
        Integer fieldIndex = this.fieldNames.get(fieldName);
        if (fieldIndex == null) {
            return null;
        }
        int i = fieldIndex * 2;
        if (this.fieldPositions[i] == -1) {
            return null;
        }
        return new TextRange(this.fieldPositions[i], this.fieldPositions[i + 1]);
    }

    public String getFieldText(String fieldName) {
        Integer fieldIndex = this.fieldNames.get(fieldName);
        if (fieldIndex == null) {
            return null;
        }
        int i = fieldIndex * 2;
        if (this.fieldPositions[i] == -1) {
            return null;
        }
        return this.message.substring(this.fieldPositions[i], this.fieldPositions[i + 1]);
    }

    public Set<String> getFieldNames() {
        return this.fieldNames.keySet();
    }

    public String toString() {
        return this.message;
    }

    @Override
    public int compareTo(LogRecord o) {
        int res = Long.compare(this.timeNanos, o.timeNanos);
        if (res != 0) {
            return res;
        }
        res = this.logId.compareTo(o.logId);
        if (res != 0) {
            return res;
        }
        return Long.compare(this.start, o.start);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.logId);
        out.writeObject(this.message);
        out.writeLong(this.timeNanos);
        out.writeLong(this.start);
        out.writeLong(this.end);
        out.writeInt(this.loadedTextLengthBytes);
        assert (this.fieldNames.size() * 2 == this.fieldPositions.length);
        out.writeShort(this.fieldNames.size());
        for (int fieldPosition : this.fieldPositions) {
            out.writeInt(fieldPosition);
        }
        Object object = this.fieldNames.keySet().iterator();
        while (object.hasNext()) {
            String fieldName = (String)object.next();
            out.writeUTF(fieldName);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        this.logId = in.readUTF();
        this.message = (String)in.readObject();
        this.timeNanos = in.readLong();
        this.start = in.readLong();
        this.end = in.readLong();
        this.loadedTextLengthBytes = in.readInt();
        int fieldCount = in.readUnsignedShort();
        this.fieldPositions = new int[fieldCount * 2];
        for (i = 0; i < this.fieldPositions.length; ++i) {
            this.fieldPositions[i] = in.readInt();
        }
        this.fieldNames = new LinkedHashMap<String, Integer>();
        for (i = 0; i < fieldCount; ++i) {
            this.fieldNames.put(in.readUTF(), i);
        }
    }

    @NonNull
    public static LogRecord createUnparsedRecord(@NonNull String message, long time, long start, long end, int loadedTextLengthBytes) {
        return new LogRecord(message, time, start, end, loadedTextLengthBytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogRecord record = (LogRecord)o;
        return this.timeNanos == record.timeNanos && this.start == record.start && this.end == record.end && this.loadedTextLengthBytes == record.loadedTextLengthBytes && this.logId.equals(record.logId) && this.message.equals(record.message) && Arrays.equals(this.fieldPositions, record.fieldPositions) && this.fieldNames.keySet().equals(record.fieldNames.keySet());
    }

    public int hashCode() {
        return this.message.hashCode();
    }
}

