/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2;

import com.logviewer.data2.FavoriteLogService;
import com.logviewer.data2.config.ConfigDirHolder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class FileFavoriteLogService
implements FavoriteLogService,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(FileFavoriteLogService.class);
    private static final String KNOWN_LOGS_FILE = "favorites-logs.txt";
    private final List<String> favorites = new LinkedList<String>();
    private final Path favoritesFile;

    public FileFavoriteLogService(ConfigDirHolder environment) {
        this.favoritesFile = environment.getConfigDir().resolve(KNOWN_LOGS_FILE);
    }

    public void afterPropertiesSet() {
        this.favorites.clear();
        if (Files.isRegularFile(this.favoritesFile, new LinkOption[0])) {
            try {
                for (String s : Files.readAllLines(this.favoritesFile, StandardCharsets.UTF_8)) {
                    if ((s = s.trim()).isEmpty() || s.startsWith("#")) continue;
                    this.favorites.add(s);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getFavorites() {
        List<String> list = this.favorites;
        synchronized (list) {
            return new ArrayList<String>(this.favorites);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> addFavoriteLog(String path) {
        List<String> list = this.favorites;
        synchronized (list) {
            if (!this.favorites.contains(path)) {
                this.favorites.add(path);
            }
            this.saveFavorites();
            return new ArrayList<String>(this.favorites);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> removeFavorite(String path) {
        List<String> list = this.favorites;
        synchronized (list) {
            if (this.favorites.remove(path)) {
                this.saveFavorites();
            }
            return new ArrayList<String>(this.favorites);
        }
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    private void saveFavorites() {
        assert (Thread.holdsLock(this.favorites));
        if (Files.isRegularFile(this.favoritesFile, new LinkOption[0]) || !Files.exists(this.favoritesFile, new LinkOption[0])) {
            try {
                Files.write(this.favoritesFile, this.favorites, new OpenOption[0]);
            }
            catch (IOException e) {
                LOG.error("Failed to save known logs list", (Throwable)e);
            }
        }
    }
}

