/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2;

import com.logviewer.utils.Utils;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

public class BufferedFile {
    private final SeekableByteChannel channel;
    private static final int ARRAY_LENGTH = 131072;
    private final byte[] array = new byte[131072];
    private final ByteBuffer buf = ByteBuffer.wrap(this.array);
    private long loadedPage;
    private int loadedPageCount;
    private final long size;

    public BufferedFile(SeekableByteChannel channel, long size) {
        this.channel = channel;
        this.size = size;
    }

    public boolean search(long position, SearchConsumer consumer) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException();
        }
        if (position > this.size) {
            throw new EOFException();
        }
        while (true) {
            if (position == this.size) {
                consumer.end(position);
                return true;
            }
            long page = position >>> 16;
            this.loadOnePage(page);
            long winOffset = this.loadedPage << 16;
            long winEnd = Math.min(winOffset + (long)(65536 * this.loadedPageCount), this.size);
            assert (winOffset <= position && position < winEnd);
            if (!consumer.data(this.array, (int)(position - winOffset), (int)(winEnd - position), position)) {
                return false;
            }
            position = winEnd;
        }
    }

    public boolean searchBack(long position, SearchConsumer consumer) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException();
        }
        if (position > this.size) {
            throw new EOFException();
        }
        while (position > 0L) {
            long page = position - 1L >>> 16;
            this.loadOnePage(page);
            long winOffset = this.loadedPage << 16;
            long winEnd = Math.min(winOffset + (long)(65536 * this.loadedPageCount), this.size);
            assert (winOffset <= position - 1L && position - 1L < winEnd);
            if (!consumer.data(this.array, 0, (int)(position - winOffset), winOffset)) {
                return false;
            }
            position = winOffset;
        }
        consumer.end(0L);
        return true;
    }

    private void loadOnePage(long page) throws IOException {
        if (this.loadedPageCount == 1) {
            if (this.loadedPage == page) {
                return;
            }
            if (this.loadedPage + 1L == page) {
                this.loadSecondPage();
                return;
            }
        } else if (this.loadedPageCount == 2 && (this.loadedPage == page || this.loadedPage + 1L == page)) {
            return;
        }
        long winPos = page << 16;
        this.buf.position(0);
        this.buf.limit((int)Math.min(this.size - winPos, 65536L));
        this.channel.position(winPos);
        Utils.readFully(this.channel, this.buf);
        this.loadedPage = page;
        this.loadedPageCount = 1;
    }

    private void loadTwoPages(long page) throws IOException {
        long winPos = page << 16;
        this.buf.position(0);
        this.buf.limit((int)Math.min(this.size - winPos, 131072L));
        assert (this.buf.limit() > 65536);
        this.channel.position(winPos);
        Utils.readFully(this.channel, this.buf);
        this.loadedPage = page;
        this.loadedPageCount = 2;
    }

    private void loadSecondPage() throws IOException {
        assert (this.loadedPageCount == 1);
        long winPos = this.loadedPage + 1L << 16;
        this.buf.limit(65536 + (int)Math.min(this.size - winPos, 65536L));
        this.buf.position(65536);
        this.channel.position(winPos);
        Utils.readFully(this.channel, this.buf);
        this.loadedPageCount = 2;
    }

    public ByteBuffer read(long position, long length) throws IOException {
        if (length > 65536L || position < 0L || length < 0L) {
            throw new IllegalArgumentException();
        }
        if (length == 0L) {
            return Utils.EMPTY_BYTE_BUFFER;
        }
        if (position + length > this.size) {
            throw new EOFException();
        }
        long startPage = position >>> 16;
        long endPage = position + length - 1L >>> 16;
        if (startPage == endPage) {
            this.loadOnePage(startPage);
        } else {
            assert (startPage + 1L == endPage);
            if (this.loadedPageCount == 0) {
                this.loadTwoPages(startPage);
            } else if (this.loadedPageCount == 1) {
                if (this.loadedPage == startPage) {
                    this.loadSecondPage();
                } else {
                    this.loadTwoPages(startPage);
                }
            } else if (this.loadedPageCount == 2) {
                if (this.loadedPage != startPage) {
                    this.loadTwoPages(startPage);
                }
            } else assert (false);
        }
        long winPos = this.loadedPage << 16;
        int newPosition = (int)(position - winPos);
        this.buf.limit((int)((long)newPosition + length));
        this.buf.position(newPosition);
        return this.buf;
    }

    public boolean loadPrevLine(Line line) throws IOException {
        return this.loadPrevLine(line, line.getStart());
    }

    public boolean loadPrevLine(Line line, long prevLineStart) throws IOException {
        if (prevLineStart == 0L) {
            return false;
        }
        class PrevLineSearcher
        extends Search10Consumer {
            private boolean was10;
            private boolean was13;
            private long firstNonLBPosition = -1L;

            PrevLineSearcher() {
            }

            @Override
            public int searchIndex(byte[] buf, int bufOffset, int length, long position) {
                if (this.firstNonLBPosition == -1L) {
                    assert (length > 0);
                    if (!this.was10 && buf[bufOffset + length - 1] == 10) {
                        this.was10 = true;
                        if (--length == 0) {
                            return -1;
                        }
                    }
                    if (!this.was13 && buf[bufOffset + length - 1] == 13) {
                        this.was13 = true;
                        if (--length == 0) {
                            return -1;
                        }
                    }
                    if (!this.was10 && buf[bufOffset + length - 1] == 10) {
                        this.was10 = true;
                        if (--length == 0) {
                            return -1;
                        }
                    }
                    this.firstNonLBPosition = position + (long)length;
                }
                for (int i = bufOffset + length - 1; i >= bufOffset; --i) {
                    if (buf[i] != 10) continue;
                    return i;
                }
                return -1;
            }
        }
        PrevLineSearcher searcher = new PrevLineSearcher();
        this.searchBack(prevLineStart, searcher);
        if (searcher.firstNonLBPosition == -1L) {
            assert (searcher.end == 0L);
            line.start = 0L;
            line.end = 0L;
            Line.access$302(line, Utils.EMPTY_BYTE_ARRAY);
            line.bufOffset = 0;
            line.dataLength = 0;
            return true;
        }
        line.start = searcher.res == -1L ? 0L : searcher.res + 1L;
        line.end = searcher.firstNonLBPosition;
        long readLength = Math.min(line.end - line.start, 32768L);
        ByteBuffer byteBuffer = this.read(line.start, readLength);
        Line.access$302(line, byteBuffer.array());
        line.bufOffset = byteBuffer.position();
        line.dataLength = byteBuffer.remaining();
        line.trim13();
        return true;
    }

    public boolean loadNextLine(Line line, long prevLineEnd) throws IOException {
        long lineEnd;
        class NextLineSearcher
        extends Search10Consumer {
            private boolean was10;
            private boolean was13;
            private long firstNonLBPosition = -1L;

            NextLineSearcher() {
            }

            @Override
            public int searchIndex(byte[] buf, int bufOffset, int length, long position) {
                if (this.firstNonLBPosition == -1L) {
                    assert (length > 0);
                    if (!this.was10 && buf[bufOffset] == 10) {
                        this.was10 = true;
                        ++bufOffset;
                        ++position;
                        if (--length == 0) {
                            return -1;
                        }
                    }
                    if (!this.was13 && buf[bufOffset] == 13) {
                        this.was13 = true;
                        ++bufOffset;
                        ++position;
                        if (--length == 0) {
                            return -1;
                        }
                    }
                    if (!this.was10 && buf[bufOffset] == 10) {
                        this.was10 = true;
                        ++bufOffset;
                        ++position;
                        if (--length == 0) {
                            return -1;
                        }
                    }
                    this.firstNonLBPosition = position;
                }
                return super.searchIndex(buf, bufOffset, length, position);
            }
        }
        NextLineSearcher searcher = new NextLineSearcher();
        this.search(prevLineEnd, searcher);
        if (searcher.firstNonLBPosition == -1L) {
            assert (searcher.end != -1L);
            if (searcher.end == prevLineEnd) {
                return false;
            }
            line.start = searcher.end;
            line.end = searcher.end;
            Line.access$302(line, Utils.EMPTY_BYTE_ARRAY);
            line.bufOffset = 0;
            line.dataLength = 0;
            return true;
        }
        if (searcher.res == -1L) {
            assert (searcher.end != -1L);
            lineEnd = searcher.end;
        } else {
            lineEnd = searcher.res;
        }
        line.start = searcher.firstNonLBPosition;
        line.end = lineEnd;
        long readLength = Math.min(lineEnd - line.start, 32768L);
        ByteBuffer byteBuffer = this.read(line.start, readLength);
        Line.access$302(line, byteBuffer.array());
        line.bufOffset = byteBuffer.position();
        line.dataLength = byteBuffer.remaining();
        line.trim13();
        return true;
    }

    public boolean loadNextLine(Line line) throws IOException {
        return this.loadNextLine(line, line.end);
    }

    public void loadLine(Line line, long position) throws IOException {
        Search10Consumer forwardSearch = new Search10Consumer();
        this.search(position, forwardSearch);
        long lineEnd = forwardSearch.res != -1L ? forwardSearch.res : forwardSearch.end;
        IndexSearchConsumer backSearch = new IndexSearchConsumer(){

            @Override
            public int searchIndex(byte[] buf, int bufOffset, int length, long position) {
                for (int i = bufOffset + length - 1; i >= bufOffset; --i) {
                    if (buf[i] != 10) continue;
                    return i;
                }
                return -1;
            }
        };
        this.searchBack(position, backSearch);
        line.start = backSearch.res == -1L ? 0L : backSearch.res + 1L;
        line.end = lineEnd;
        long readLength = Math.min(lineEnd - line.start, 32768L);
        ByteBuffer byteBuffer = this.read(line.start, readLength);
        Line.access$302(line, byteBuffer.array());
        line.bufOffset = byteBuffer.position();
        line.dataLength = byteBuffer.remaining();
        line.trim13();
    }

    public static class Line {
        private long start;
        private long end;
        private byte[] buf = Utils.EMPTY_BYTE_ARRAY;
        private int bufOffset;
        private int dataLength;

        public Line() {
        }

        public Line(String s) {
            this.buf = s.getBytes();
            this.start = 0L;
            this.end = this.buf.length;
            this.dataLength = this.buf.length;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public int getBufOffset() {
            return this.bufOffset;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        private void trim13() {
            if (this.dataLength > 0 && this.buf[this.bufOffset + this.dataLength - 1] == 13) {
                --this.end;
                --this.dataLength;
            }
        }

        public String toString() {
            return new String(this.buf, this.bufOffset, this.dataLength) + " [" + this.start + ", " + this.end + ']';
        }

        static /* synthetic */ byte[] access$302(Line x0, byte[] x1) {
            x0.buf = x1;
            return x1;
        }
    }

    public static abstract class IndexSearchConsumer
    implements SearchConsumer {
        long res = -1L;
        long end = -1L;

        @Override
        public final boolean data(byte[] buf, int bufOffset, int length, long position) {
            int res = this.searchIndex(buf, bufOffset, length, position);
            if (res >= 0) {
                this.res = (long)(res - bufOffset) + position;
                return false;
            }
            return true;
        }

        public abstract int searchIndex(byte[] var1, int var2, int var3, long var4);

        @Override
        public void end(long position) {
            this.end = position;
        }
    }

    public static class Search10Consumer
    extends IndexSearchConsumer {
        @Override
        public int searchIndex(byte[] buf, int bufOffset, int length, long position) {
            int end = bufOffset + length;
            for (int i = bufOffset; i < end; ++i) {
                if (buf[i] != 10) continue;
                return i;
            }
            return -1;
        }
    }

    public static interface SearchConsumer {
        public boolean data(byte[] var1, int var2, int var3, long var4);

        default public void end(long position) {
        }
    }
}

