/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.web.session.tasks;

import com.logviewer.data2.LogRecord;
import com.logviewer.data2.LogView;
import com.logviewer.data2.Position;
import com.logviewer.data2.RecordList;
import com.logviewer.filters.RecordPredicate;
import com.logviewer.utils.Pair;
import com.logviewer.web.session.LogDataListener;
import com.logviewer.web.session.LogProcess;
import com.logviewer.web.session.SearchResult;
import com.logviewer.web.session.SessionAdapter;
import com.logviewer.web.session.SessionTask;
import com.logviewer.web.session.Status;
import com.logviewer.web.session.tasks.LoadNextResponse;
import com.logviewer.web.session.tasks.LoadRecordTask;
import com.logviewer.web.session.tasks.SearchPattern;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class SearchTask
extends SessionTask<SearchResponse> {
    private final Position start;
    private final int recordCount;
    private final boolean backward;
    private final RecordPredicate filter;
    private final SearchPattern pattern;
    private final Map<String, String> hashes;
    private final Map<LogView, LogProcess> searchers = new IdentityHashMap<LogView, LogProcess>();
    private final Map<LogView, LogProcess> recordLoaders = new IdentityHashMap<LogView, LogProcess>();
    private boolean finished;

    public SearchTask(SessionAdapter sender, LogView[] logs, Position start, int recordCount, boolean backward, @NonNull SearchPattern pattern, @NonNull Map<String, String> hashes, @Nullable RecordPredicate filter) {
        super(sender, logs);
        this.start = start;
        this.recordCount = recordCount;
        this.backward = backward;
        this.pattern = pattern;
        this.filter = filter;
        this.hashes = hashes;
    }

    @Override
    public synchronized void execute(BiConsumer<SearchResponse, Throwable> consumer) {
        HashMap statuses = new HashMap();
        HashMap resultPerLog = new HashMap();
        for (LogView log : this.logs) {
            String hash = this.hashes.get(log.getId());
            if (hash == null) continue;
            LogProcess searcher = log.createRecordSearcher(this.start, this.backward, this.filter, hash, this.recordCount, this.pattern, searchResult -> {
                SearchTask searchTask = this;
                synchronized (searchTask) {
                    if (this.finished) {
                        return;
                    }
                    resultPerLog.put(log.getId(), searchResult);
                    statuses.put(log.getId(), searchResult.getStatus());
                    if (resultPerLog.size() == this.searchers.size()) {
                        this.processSearchResults(resultPerLog, statuses, consumer);
                    } else if (searchResult.isFound()) {
                        for (Map.Entry<LogView, LogProcess> entry : this.searchers.entrySet()) {
                            if (entry.getKey() == log) continue;
                            Pair pair = (Pair)searchResult.getData().get(searchResult.getData().size() - 1);
                            long time = ((LogRecord)pair.getFirst()).getTime();
                            entry.getValue().setTimeLimit(LogProcess.makeTimeLimitNonStrict(this.backward, time));
                        }
                    }
                }
            });
            this.searchers.put(log, searcher);
        }
        this.searchers.values().forEach(LogProcess::start);
    }

    private void processSearchResults(Map<String, SearchResult> resultPerLog, final Map<String, Status> statuses, final BiConsumer<SearchResponse, Throwable> consumer) {
        final Comparator<Pair<LogRecord, Throwable>> recordComparator = this.backward ? LoadRecordTask.PAIR_COMPARATOR.reversed() : LoadRecordTask.PAIR_COMPARATOR;
        Optional<Pair<LogRecord, Throwable>> firstOccurrence = resultPerLog.values().stream().filter(SearchResult::isFound).map(r -> (Pair)r.getData().get(r.getData().size() - 1)).min(recordComparator);
        if (!firstOccurrence.isPresent()) {
            this.finished = true;
            consumer.accept(new SearchResponse(null, statuses), null);
            return;
        }
        Pair<LogRecord, Throwable> o = firstOccurrence.get();
        final List<Pair<LogRecord, Throwable>> records = resultPerLog.values().stream().filter(r -> r.getStatus().getError() == null).flatMap(r -> r.getData().stream()).filter(p -> recordComparator.compare(o, (Pair<LogRecord, Throwable>)p) >= 0).sorted(recordComparator).collect(Collectors.toList());
        assert (records.get(records.size() - 1) == o);
        if (records.size() > this.recordCount) {
            records.subList(0, records.size() - this.recordCount).clear();
            assert (records.size() == this.recordCount);
        }
        final HashSet finishedLoaders = new HashSet();
        for (final LogView log : this.searchers.keySet()) {
            Position start;
            int maxRecordToLoad;
            SearchResult r2;
            if (log.getId().equals(o.getFirst().getLogId()) || (r2 = resultPerLog.get(log.getId())).getStatus().getError() != null || !r2.isHasSkippedLine() || r2.getData().isEmpty()) continue;
            final Pair lastReturnedRecord = (Pair)r2.getData().get(0);
            if (recordComparator.compare(lastReturnedRecord, o) < 0) {
                int index = Collections.binarySearch(records, lastReturnedRecord, recordComparator);
                if (index < 0) {
                    index = -index - 1;
                }
                maxRecordToLoad = index;
                start = new Position((LogRecord)lastReturnedRecord.getFirst(), !this.backward);
            } else {
                maxRecordToLoad = this.recordCount - 1;
                start = new Position(o.getFirst());
            }
            String hash = this.hashes.get(log.getId());
            assert (hash != null);
            LogProcess recordLoader = log.loadRecords(this.filter, maxRecordToLoad, start, !this.backward, hash, Long.MAX_VALUE, new LogDataListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onData(@NonNull RecordList data) {
                    assert (recordComparator.compare(data.get(0), lastReturnedRecord) < 0);
                    assert (recordComparator.compare(data.get(data.size() - 1), lastReturnedRecord) < 0);
                    SearchTask searchTask = SearchTask.this;
                    synchronized (searchTask) {
                        if (SearchTask.this.finished) {
                            return;
                        }
                        records.addAll(data);
                        if (SearchTask.this.logs.length > 1) {
                            records.sort(recordComparator);
                        }
                        if (records.size() > SearchTask.this.recordCount) {
                            records.subList(0, records.size() - SearchTask.this.recordCount).clear();
                            assert (records.size() == SearchTask.this.recordCount);
                        }
                        if (records.size() == SearchTask.this.recordCount) {
                            SearchTask.this.recordLoaders.values().forEach(l -> {
                                long time = ((LogRecord)((Pair)records.get(0)).getFirst()).getTime();
                                l.setTimeLimit(LogProcess.makeTimeLimitNonStrict(!SearchTask.this.backward, time));
                            });
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFinish(@NonNull Status status, boolean eof) {
                    SearchTask searchTask = SearchTask.this;
                    synchronized (searchTask) {
                        if (SearchTask.this.finished) {
                            return;
                        }
                        if (finishedLoaders.add(log.getId())) {
                            if (status.getError() != null) {
                                statuses.put(log.getId(), status);
                            }
                            if (finishedLoaders.size() == SearchTask.this.recordLoaders.size()) {
                                consumer.accept(new SearchResponse(records, statuses), null);
                            }
                        }
                    }
                }
            });
            long timeLimit = records.size() == this.recordCount ? records.get(0).getFirst().getTime() : this.start.getTime();
            recordLoader.setTimeLimit(LogProcess.makeTimeLimitNonStrict(!this.backward, timeLimit));
            this.recordLoaders.put(log, recordLoader);
        }
        if (this.recordLoaders.isEmpty()) {
            consumer.accept(new SearchResponse(records, statuses), null);
            return;
        }
        this.recordLoaders.values().forEach(LogProcess::start);
    }

    @Override
    public synchronized void cancel() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.searchers.values().forEach(LogProcess::cancel);
        this.recordLoaders.values().forEach(LogProcess::cancel);
    }

    public class SearchResponse
    extends LoadNextResponse {
        private final boolean hasSkippedLine;

        SearchResponse(List<Pair<LogRecord, Throwable>> data, Map<String, Status> statuses) {
            super(data, statuses, data == null);
            if (SearchTask.this.backward && data != null) {
                Collections.reverse(data);
            }
            this.hasSkippedLine = data != null && data.size() == SearchTask.this.recordCount;
        }

        public boolean hasSkippedLine() {
            return this.hasSkippedLine;
        }
    }
}

