/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.web.session;

import com.logviewer.data2.LogCrashedException;
import com.logviewer.data2.LogRecord;
import com.logviewer.data2.LvPredicateChecker;
import com.logviewer.data2.Position;
import com.logviewer.data2.RecordList;
import com.logviewer.data2.Snapshot;
import com.logviewer.filters.RecordPredicate;
import com.logviewer.utils.Pair;
import com.logviewer.utils.PredicateUtils;
import com.logviewer.web.session.LogDataListener;
import com.logviewer.web.session.LogProcess;
import com.logviewer.web.session.Status;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class LocalFileRecordLoader
implements LogProcess {
    private final Supplier<Snapshot> snapshotFactory;
    private final ExecutorService executor;
    private final LogDataListener listener;
    private final Position start;
    private final RecordPredicate filter;
    private final Long timeLimitFomFilter;
    private final int recordCountLimit;
    private final boolean backward;
    private final long sizeLimit;
    private final String hash;
    private int state = 0;
    private volatile long timeLimit = 0L;
    private volatile Future<?> future;

    public LocalFileRecordLoader(Supplier<Snapshot> snapshotFactory, @NonNull ExecutorService executor, LogDataListener listener, @Nullable Position start, RecordPredicate filter, boolean backward, int recordCountLimit, long sizeLimit, @Nullable String hash) {
        this.snapshotFactory = snapshotFactory;
        this.executor = executor;
        this.listener = listener;
        this.start = start;
        this.filter = filter;
        this.recordCountLimit = recordCountLimit;
        this.backward = backward;
        this.sizeLimit = sizeLimit;
        this.hash = hash;
        this.timeLimitFomFilter = PredicateUtils.extractTimeLimit(filter, !backward);
    }

    @Override
    public synchronized void start() {
        if (this.state != 0) {
            throw new IllegalStateException("Loader already started");
        }
        assert (this.future == null);
        this.future = this.executor.submit(() -> {
            try (Snapshot snapshot = this.snapshotFactory.get();){
                Status status;
                boolean processedAllLined;
                try {
                    boolean hasMoreLine;
                    if (this.hash != null && !snapshot.isValidHash(this.hash)) {
                        throw new LogCrashedException();
                    }
                    MyRecordPredicate predicate = new MyRecordPredicate(snapshot);
                    if (this.start == null) {
                        assert (this.backward);
                        Long startTime = PredicateUtils.extractTimeLimit(this.filter, true);
                        hasMoreLine = startTime != null ? snapshot.processFromTimeBack(startTime, predicate) : snapshot.processRecordsBack(snapshot.getSize(), false, predicate);
                    } else {
                        hasMoreLine = this.searchFromPosition(snapshot, predicate);
                    }
                    processedAllLined = hasMoreLine || predicate.stoppedByFilterTimeLimit;
                    status = new Status(snapshot);
                }
                catch (Throwable e) {
                    processedAllLined = false;
                    status = new Status(e);
                }
                this.listener.onFinish(status, processedAllLined);
            }
        });
        this.state = 1;
    }

    private boolean timeOk(LogRecord record) {
        long timeLimit = this.timeLimit;
        if (timeLimit <= 0L) {
            return true;
        }
        long time = record.getTime();
        if (time <= 0L) {
            return true;
        }
        if (this.backward) {
            return time > timeLimit;
        }
        return time < timeLimit;
    }

    @Override
    public synchronized void cancel() {
        if (this.state == 0) {
            throw new IllegalStateException("Loader is not started");
        }
        if (this.state == 1) {
            this.future.cancel(true);
            this.state = 2;
        }
    }

    @Override
    public void setTimeLimit(long limit) {
        this.timeLimit = limit;
    }

    private boolean searchFromPosition(Snapshot snapshot, Predicate<LogRecord> predicate) throws IOException {
        Long startTimeFromFilters = PredicateUtils.extractTimeLimit(this.filter, this.backward);
        int idCmp = this.start.getLogId().compareTo(snapshot.getLog().getId());
        if (idCmp == 0) {
            boolean res;
            AtomicBoolean wrongDateFlag = new AtomicBoolean();
            AtomicBoolean firstRecordProcessedFlag = new AtomicBoolean();
            if (this.backward) {
                res = snapshot.processRecordsBack(this.start.getLocalPosition(), true, rec -> {
                    if (startTimeFromFilters != null && rec.hasTime() && !firstRecordProcessedFlag.get() && rec.getTime() > startTimeFromFilters) {
                        wrongDateFlag.set(true);
                        return false;
                    }
                    firstRecordProcessedFlag.set(true);
                    return predicate.test((LogRecord)rec);
                });
                if (wrongDateFlag.get()) {
                    return snapshot.processFromTimeBack(startTimeFromFilters, predicate);
                }
            } else {
                res = snapshot.processRecords(this.start.getLocalPosition(), true, rec -> {
                    if (startTimeFromFilters != null && rec.hasTime() && !firstRecordProcessedFlag.get() && rec.getTime() < startTimeFromFilters) {
                        wrongDateFlag.set(true);
                        return false;
                    }
                    firstRecordProcessedFlag.set(true);
                    return predicate.test((LogRecord)rec);
                });
                if (wrongDateFlag.get()) {
                    return snapshot.processFromTime(startTimeFromFilters, predicate);
                }
            }
            return res;
        }
        if (this.backward) {
            long startTime = idCmp < 0 ? this.start.getTime() - 1L : this.start.getTime();
            if (startTimeFromFilters != null && startTime > startTimeFromFilters) {
                startTime = startTimeFromFilters;
            }
            return snapshot.processFromTimeBack(startTime, predicate);
        }
        long startTime = idCmp < 0 ? this.start.getTime() : this.start.getTime() + 1L;
        if (startTimeFromFilters != null && startTime < startTimeFromFilters) {
            startTime = startTimeFromFilters;
        }
        return snapshot.processFromTime(startTime, predicate);
    }

    private class MyRecordPredicate
    implements Predicate<LogRecord> {
        private final LvPredicateChecker predicateChecker;
        private long readSize;
        private int recordCount;
        private boolean stoppedByFilterTimeLimit;

        public MyRecordPredicate(Snapshot snapshot) {
            this.predicateChecker = new LvPredicateChecker(snapshot.getLog());
        }

        @Override
        public boolean test(LogRecord record) {
            if (LocalFileRecordLoader.this.timeLimitFomFilter != null && record.hasTime() && (LocalFileRecordLoader.this.backward ? record.getTime() < LocalFileRecordLoader.this.timeLimitFomFilter : record.getTime() > LocalFileRecordLoader.this.timeLimitFomFilter)) {
                this.stoppedByFilterTimeLimit = true;
                return false;
            }
            if (!LocalFileRecordLoader.this.timeOk(record)) {
                return false;
            }
            Pair<LogRecord, Throwable> restRecord = this.predicateChecker.applyFilter(record, LocalFileRecordLoader.this.filter);
            if (restRecord != null) {
                ++this.recordCount;
                this.readSize += (long)record.getMessage().length();
                LocalFileRecordLoader.this.listener.onData(new RecordList(restRecord));
            }
            return this.recordCount < LocalFileRecordLoader.this.recordCountLimit && this.readSize < LocalFileRecordLoader.this.sizeLimit;
        }
    }
}

