/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.web.dto.events;

import com.logviewer.data2.FavoriteLogService;
import com.logviewer.data2.LogView;
import com.logviewer.utils.Utils;
import com.logviewer.web.dto.RestLog;
import com.logviewer.web.dto.events.BackendEvent;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EventSetViewState
extends BackendEvent {
    private List<RestLog> logs;
    private String uiConfig;
    private boolean inFavorites;
    private boolean favEditable;
    private boolean initByPermalink;
    private final Map<String, String> globalSavedFilters;
    private final String localhostName = Utils.LOCAL_HOST_NAME;

    public EventSetViewState(LogView[] logs, Config uiConfig, FavoriteLogService favoriteLogService, Map<String, String> globalSavedFilters, boolean initByPermalink) {
        this.logs = Stream.of(logs).map(RestLog::new).collect(Collectors.toList());
        this.uiConfig = uiConfig.root().render(ConfigRenderOptions.concise());
        this.favEditable = favoriteLogService.isEditable();
        this.globalSavedFilters = globalSavedFilters;
        this.initByPermalink = initByPermalink;
    }

    public String getUiConfig() {
        return this.uiConfig;
    }

    @Override
    public String getName() {
        return "onSetViewState";
    }
}

