/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.web.dto;

import com.logviewer.data2.DirectoryNotVisibleException;
import com.logviewer.data2.IncorrectFormatException;
import com.logviewer.data2.LogCrashedException;
import com.logviewer.utils.Utils;
import com.logviewer.web.session.LogSession;
import com.logviewer.web.session.Status;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.channels.UnresolvedAddressException;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestStatus {
    private static final Logger log = LoggerFactory.getLogger(RestStatus.class);
    private String errorType;
    private String errorMessage;
    private String detailedErrorMessage;
    private Map<String, Object> metainfo;
    private String hash;
    private long size;
    private long lastModification;

    public RestStatus(Status status) {
        if (status.getHash() != null) {
            this.hash = status.getHash();
            this.size = status.getSize();
            this.lastModification = status.getLastModification();
        } else {
            Throwable exception = status.getError();
            if (exception instanceof NoSuchFileException) {
                this.errorType = "NoSuchFileException";
            } else if (exception instanceof AccessDeniedException) {
                this.errorType = "AccessDeniedException";
            } else if (exception instanceof DirectoryNotVisibleException) {
                this.errorType = "DirectoryNotVisibleException";
            } else if (exception instanceof ConnectException && exception.getMessage().equals("Connection refused")) {
                this.errorType = "ConnectionProblem";
            } else if (exception instanceof UnresolvedAddressException) {
                this.errorType = "ConnectionProblem";
                this.errorMessage = "Unresolved host";
            } else if (exception == LogSession.NO_DATE_EXCEPTION) {
                this.errorType = "NoDateField";
            } else if (exception instanceof IncorrectFormatException) {
                this.errorType = "IncorrectFormatException";
                IncorrectFormatException e = (IncorrectFormatException)exception;
                this.metainfo = new HashMap<String, Object>();
                this.metainfo.put("start", e.getBlockStart());
                this.metainfo.put("end", e.getBlockStart());
                this.metainfo.put("format", e.getFormat());
            } else if (exception instanceof IOException) {
                this.errorType = "IOException";
                this.detailedErrorMessage = Utils.getStackTraceAsString(exception);
            } else if (exception instanceof LogCrashedException) {
                this.errorType = "LogCrashedException";
            } else {
                log.error("Unknown error", exception);
                this.errorType = "internal_error";
                this.detailedErrorMessage = Utils.getStackTraceAsString(exception);
            }
            if (this.errorMessage == null) {
                this.errorMessage = exception.getMessage();
            }
        }
    }

    public String getDetailedErrorMessage() {
        return this.detailedErrorMessage;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getHash() {
        return this.hash;
    }

    public long getSize() {
        return this.size;
    }
}

