/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.web;

import com.logviewer.data2.LogContextHolder;
import com.logviewer.utils.Utils;
import com.logviewer.web.AbstractRestRequestHandler;
import com.logviewer.web.LogNavigatorController;
import com.logviewer.web.LogViewController;
import com.logviewer.web.WebsocketEmulationController;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.NonNull;
import org.springframework.util.StreamUtils;

public class LogViewerServlet
extends HttpServlet {
    public static final String SPRING_CONTEXT_PROPERTY = "org.springframework.web.context.WebApplicationContext.ROOT";
    private static final Pattern[] RESOURCE_PATTERNS = new Pattern[]{Pattern.compile("/fa-(?:brands|regular|solid)-\\d+(\\.[0-9a-f]{20})?\\.[a-z0-9]+"), Pattern.compile("/MaterialIcons-Regular(\\.[0-9a-f]{20})?\\.[a-z0-9]+"), Pattern.compile("/[\\w\\-]+(\\.[0-9a-f]{20})?\\.(?:png|gif)"), Pattern.compile("/(?:main|polyfills|runtime|styles|vendor)(\\.[0-9a-f]{20})?\\.(?:css|js|js\\.map|css\\.map)")};
    private static final Map<String, String> MIME_TYPES_MAP = Utils.newMap("css", "text/css", "js", "application/javascript");
    private volatile String indexHtml;
    private final Map<String, ResourceCache> resourceCache = new ConcurrentHashMap<String, ResourceCache>();
    private Map<String, AbstractRestRequestHandler> restHandlers;

    public void init() {
        ApplicationContext logContext = this.getSpringContext();
        this.restHandlers = Utils.newMap("navigator", LogViewerServlet.injectDeps(logContext, new LogNavigatorController()), "ws-emulator", LogViewerServlet.injectDeps(logContext, new WebsocketEmulationController()), "log-view", LogViewerServlet.injectDeps(logContext, new LogViewController()));
    }

    private static <T> T injectDeps(ApplicationContext logContext, T controller) {
        logContext.getAutowireCapableBeanFactory().autowireBeanProperties(controller, 0, false);
        return controller;
    }

    protected ApplicationContext getSpringContext() {
        ApplicationContext appCtx = LogContextHolder.getInstance();
        if (appCtx != null) {
            return appCtx;
        }
        appCtx = (ApplicationContext)this.getServletConfig().getServletContext().getAttribute(SPRING_CONTEXT_PROPERTY);
        if (appCtx != null) {
            return appCtx;
        }
        throw new IllegalStateException("Spring context not found. Set ApplicationContext to com.logviewer.data2.LogContextHolder.setInstance(appCtx)");
    }

    private String getRelativePath(HttpServletRequest req) {
        String servletMappingPath = req.getContextPath() + req.getServletPath();
        assert (req.getRequestURI().startsWith(servletMappingPath)) : "[req.getRequestURI()=" + req.getRequestURI() + ", req.getContextPath()=" + req.getContextPath() + ", req.getServletPath()=" + req.getServletPath();
        String uri = req.getRequestURI().substring(servletMappingPath.length());
        assert (uri.startsWith("/") || uri.isEmpty());
        return uri;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String restPrefix;
        String relativePath = this.getRelativePath(req);
        if (!relativePath.startsWith(restPrefix = "/rest/")) {
            resp.setStatus(404);
            return;
        }
        int idx = relativePath.indexOf("/", restPrefix.length());
        if (idx < 0) {
            resp.setStatus(404);
            return;
        }
        AbstractRestRequestHandler handler = this.restHandlers.get(relativePath.substring(restPrefix.length(), idx));
        if (handler == null) {
            resp.setStatus(404);
            return;
        }
        handler.process(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        long ifModifiedSince;
        ResourceCache cache;
        String relativePath = this.getRelativePath(req);
        if (relativePath.equals("") || relativePath.equals("/")) {
            this.processIndexHtml(req, resp, relativePath);
            return;
        }
        if (relativePath.startsWith("/rest/")) {
            int idx = relativePath.indexOf("/", "/rest/".length());
            if (idx < 0) {
                resp.setStatus(404);
                return;
            }
            AbstractRestRequestHandler handler = this.restHandlers.get(relativePath.substring("/rest/".length(), idx));
            if (handler == null) {
                resp.setStatus(404);
                return;
            }
            handler.process(req, resp);
            return;
        }
        Boolean cachableRes = null;
        if (relativePath.startsWith("/assets/") || relativePath.startsWith("/img/")) {
            cachableRes = true;
        } else {
            for (Pattern resourcePattern : RESOURCE_PATTERNS) {
                Matcher matcher = resourcePattern.matcher(relativePath);
                if (!matcher.matches()) continue;
                cachableRes = matcher.group(1) != null;
                break;
            }
        }
        if (cachableRes == null) {
            this.processIndexHtml(req, resp, relativePath);
            return;
        }
        try {
            cache = this.resourceCache.computeIfAbsent(relativePath, key -> {
                ResourceCache res;
                block15: {
                    URL resource = ((Object)((Object)this)).getClass().getResource("/log-viewer-web" + key);
                    if (resource == null) {
                        throw new IllegalArgumentException();
                    }
                    res = new ResourceCache();
                    try {
                        res.url = resource;
                        res.contentType = LogViewerServlet.detectMimeType(key);
                        if (!"jar".equals(resource.getProtocol())) break block15;
                        URLConnection urlConnection = resource.openConnection();
                        res.date = urlConnection.getLastModified();
                        res.length = urlConnection.getContentLengthLong();
                        if (res.length >= 5120L) break block15;
                        try (InputStream inputStream = urlConnection.getInputStream();){
                            ResourceCache.access$302(res, StreamUtils.copyToByteArray((InputStream)inputStream));
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return res;
            });
        }
        catch (IllegalArgumentException e) {
            resp.setStatus(404);
            return;
        }
        if (cachableRes.booleanValue()) {
            resp.setHeader("Cache-Control", "max-age=31536000");
            resp.setHeader("Pragma", "cache");
            resp.setDateHeader("Expires", System.currentTimeMillis() + 31536000000L);
        }
        if ((ifModifiedSince = req.getDateHeader("If-Modified-Since")) != -1L && cachableRes.booleanValue()) {
            resp.setStatus(304);
            return;
        }
        URLConnection urlConnection = null;
        long date = cache.date;
        if (date == -1L) {
            urlConnection = cache.url.openConnection();
            date = urlConnection.getLastModified();
        }
        if (ifModifiedSince != -1L && ifModifiedSince >= date) {
            resp.setStatus(304);
            return;
        }
        resp.addDateHeader("Last-Modified", date);
        if (cache.contentType != null) {
            resp.addHeader("Content-Type", cache.contentType);
        }
        if (cache.data != null) {
            resp.getOutputStream().write(cache.data);
        } else {
            String acceptEncoding;
            long length;
            if (urlConnection == null) {
                urlConnection = cache.url.openConnection();
            }
            if ((length = cache.length) == -1L) {
                length = urlConnection.getContentLengthLong();
            }
            if (length >= 10240L && (cache.contentType == null || !cache.contentType.startsWith("image/") && !relativePath.endsWith(".woff") && !relativePath.endsWith(".woff2")) && (acceptEncoding = req.getHeader("Accept-Encoding")) != null && acceptEncoding.contains("gzip")) {
                resp.setHeader("Content-Encoding", "gzip");
                GZIPOutputStream gzip = new GZIPOutputStream((OutputStream)resp.getOutputStream());
                try (InputStream inputStream = urlConnection.getInputStream();){
                    StreamUtils.copy((InputStream)inputStream, (OutputStream)gzip);
                }
                gzip.finish();
                return;
            }
            try (InputStream inputStream = urlConnection.getInputStream();){
                StreamUtils.copy((InputStream)inputStream, (OutputStream)resp.getOutputStream());
            }
        }
    }

    public void destroy() {
        if (this.restHandlers != null) {
            for (AbstractRestRequestHandler value : this.restHandlers.values()) {
                Utils.closeQuietly(value);
            }
        }
    }

    private String calculateRootPath(HttpServletRequest req, String relativePath) {
        if (relativePath.indexOf(47, 1) < 0) {
            return "./";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < relativePath.length(); ++i) {
            if (relativePath.charAt(i) != '/') continue;
            sb.append("../");
        }
        return sb.toString();
    }

    private void processIndexHtml(HttpServletRequest req, HttpServletResponse resp, String relativePath) throws IOException {
        String path;
        if (relativePath.isEmpty() && !(path = req.getContextPath() + req.getServletPath()).isEmpty()) {
            int slash = path.lastIndexOf(47);
            assert (slash >= 0) : path;
            String target = "." + path.substring(slash) + "/";
            if (req.getQueryString() != null) {
                target = target + '?' + req.getQueryString();
            }
            resp.sendRedirect(target);
            return;
        }
        String indexHtml = this.indexHtml;
        if (indexHtml == null) {
            URL indexHtmlUrl = ((Object)((Object)this)).getClass().getResource("/log-viewer-web/index.html");
            if (indexHtmlUrl == null) {
                resp.sendError(500, "'log-viewer-web/index.html' resource not found. It must be located in 'log-viewer-frontend-$version.jar'");
                return;
            }
            try (InputStream stream = indexHtmlUrl.openStream();){
                indexHtml = StreamUtils.copyToString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            }
            if (!indexHtmlUrl.getProtocol().equals("file")) {
                this.indexHtml = indexHtml;
            }
        }
        String rootPath = this.calculateRootPath(req, relativePath);
        indexHtml = indexHtml.replace("$PATH", rootPath);
        indexHtml = indexHtml.replace("$WEB_SOCKET_PATH", this.getWebSocketPath(rootPath));
        resp.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        resp.setContentType("text/html");
        resp.getOutputStream().print(indexHtml);
    }

    @NonNull
    private String getWebSocketPath(String rootPath) {
        String webSocketPath = this.getServletConfig().getInitParameter("web-socket-path");
        if (webSocketPath == null || webSocketPath.isEmpty()) {
            return "";
        }
        if (webSocketPath.startsWith("/")) {
            webSocketPath = webSocketPath.substring(1);
        }
        return rootPath + webSocketPath;
    }

    private static String detectMimeType(String fileName) {
        int dotIndex;
        String res = URLConnection.guessContentTypeFromName(fileName);
        if (res == null && (dotIndex = fileName.lastIndexOf(".")) >= 0) {
            res = MIME_TYPES_MAP.get(fileName.substring(dotIndex + 1));
        }
        return res;
    }

    private static class ResourceCache {
        private long date = -1L;
        private long length = -1L;
        private byte[] data;
        private URL url;
        private String contentType;

        private ResourceCache() {
        }

        static /* synthetic */ byte[] access$302(ResourceCache x0, byte[] x1) {
            x0.data = x1;
            return x1;
        }
    }
}

