/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.utils;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class LvTimer
extends Timer {
    private static final Logger LOG = LoggerFactory.getLogger(LvTimer.class);
    private final Map<Object, Boolean> uniqueTaskMap = new ConcurrentHashMap<Object, Boolean>();

    public LvTimer() {
        super("log-viewer-timer", true);
    }

    public boolean scheduleTask(final @NonNull Object key, final @NonNull Runnable task, long delay) {
        if (this.uniqueTaskMap.putIfAbsent(key, true) == null) {
            this.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        LvTimer.this.uniqueTaskMap.remove(key);
                        task.run();
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to execute scheduled task", e);
                    }
                }
            }, delay);
            return true;
        }
        return false;
    }
}

