/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.logLibs.nginx;

import com.logviewer.formats.utils.LvLayoutStretchNode;
import org.springframework.lang.NonNull;

public class NginxStretchNode
extends LvLayoutStretchNode {
    public NginxStretchNode(@NonNull String fieldName, String fieldType, boolean removeSpacesBefore) {
        super(fieldName, fieldType, removeSpacesBefore, 0);
    }

    public NginxStretchNode(@NonNull String fieldName, String fieldType, boolean removeSpacesBefore, int minSize) {
        super(fieldName, fieldType, removeSpacesBefore, minSize);
    }

    private static boolean isHex(char a) {
        return a >= '0' && a <= '9' || a >= 'a' && a <= 'f' || a >= 'A' && a <= 'F';
    }

    protected boolean isAcceptableSymbol(char a) {
        return true;
    }

    private boolean doGrow(String s, int endStr) {
        char a;
        if (this.end == endStr) {
            return false;
        }
        if ((a = s.charAt(this.end++)) != '\\') {
            return this.isAcceptableSymbol(a);
        }
        if (this.end == endStr) {
            return true;
        }
        if ((a = s.charAt(this.end++)) == 'x') {
            if (endStr - this.end < 2 || !NginxStretchNode.isHex(s.charAt(this.end)) || !NginxStretchNode.isHex(s.charAt(this.end + 1))) {
                return true;
            }
            this.end += 2;
            return true;
        }
        if (a == 'u') {
            if (!(endStr - this.end >= 4 && NginxStretchNode.isHex(s.charAt(this.end)) && NginxStretchNode.isHex(s.charAt(this.end + 1)) && NginxStretchNode.isHex(s.charAt(this.end + 2)) && NginxStretchNode.isHex(s.charAt(this.end + 3)))) {
                return true;
            }
            this.end += 4;
            return true;
        }
        return true;
    }

    @Override
    public boolean reset(String s, int start, int endStr) {
        this.start = start;
        this.end = start;
        while (this.minSize > this.end - start) {
            if (this.doGrow(s, endStr)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean grow(String s, int targetPosition, int endStr) {
        while (this.end < targetPosition) {
            if (this.doGrow(s, endStr)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NginxStretchNode clone() {
        return new NginxStretchNode(this.getFieldName(), this.getFieldType(), this.removeSpacesBefore, this.minSize);
    }
}

