/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.logLibs.nginx;

import com.logviewer.formats.AbstractPatternLogFormat;
import com.logviewer.formats.utils.LvLayoutFixedTextNode;
import com.logviewer.formats.utils.LvLayoutHexNode;
import com.logviewer.formats.utils.LvLayoutIpNode;
import com.logviewer.formats.utils.LvLayoutNode;
import com.logviewer.formats.utils.LvLayoutNumberNode;
import com.logviewer.formats.utils.LvLayoutRegexNode;
import com.logviewer.formats.utils.LvLayoutSimpleDateNode;
import com.logviewer.formats.utils.LvLayoutStretchNode;
import com.logviewer.formats.utils.LvLayoutTextNode;
import com.logviewer.logLibs.nginx.NginxOptionalNumber;
import com.logviewer.logLibs.nginx.NginxStretchNode;
import com.logviewer.logLibs.nginx.NginxStretchPatternNode;
import com.logviewer.logLibs.nginx.NginxUriNode;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.lang.NonNull;

public class NginxLogFormat
extends AbstractPatternLogFormat {
    private static final Pattern ITEM = Pattern.compile("(\\$[a-z0-9_]+)|([^$]+)");
    private static final String[] HTTP_METHODS = new String[]{"GET", "HEAD", "POST", "PUT", "PATCH", "DELETE", "OPTIONS", "TRACE"};

    public NginxLogFormat(@NonNull String pattern) {
        this(null, pattern);
    }

    public NginxLogFormat(Charset charset, @NonNull String pattern) {
        super(charset, pattern);
    }

    @Override
    protected LvLayoutNode[] parseLayout(@NonNull String pattern) throws IllegalArgumentException {
        ArrayList<LvLayoutNode> res = new ArrayList<LvLayoutNode>();
        Matcher matcher = ITEM.matcher(pattern);
        while (matcher.lookingAt()) {
            String field = matcher.group(1);
            if (field != null) {
                res.add(this.field(field.substring(1)));
            } else {
                res.add(LvLayoutTextNode.of(matcher.group()));
            }
            matcher.region(matcher.end(), pattern.length());
        }
        NginxLogFormat.mergeMessageFields(res);
        return res.toArray(new LvLayoutNode[0]);
    }

    private LvLayoutNode field(String name) {
        switch (name) {
            case "bytes_sent": {
                return new NginxOptionalNumber(name, "number/nginx_bytes_sent");
            }
            case "body_bytes_sent": {
                return new NginxOptionalNumber(name, "number/nginx_bytes_sent");
            }
            case "remote_addr": {
                return new LvLayoutIpNode(name, "number/nginx_bytes_sent");
            }
            case "remote_user": {
                return new NginxStretchNode(name, "username", true, 1);
            }
            case "time_local": {
                return new LvLayoutSimpleDateNode("dd/MMM/yyyy:HH:mm:ss Z");
            }
            case "request_method": {
                return new LvLayoutFixedTextNode(name, "HTTP_METHOD", HTTP_METHODS);
            }
            case "scheme": {
                return new LvLayoutFixedTextNode(name, "nginx_scheme", "http", "https");
            }
            case "host": 
            case "hostname": {
                return new LvLayoutRegexNode(name, "hostname", "(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])");
            }
            case "request": 
            case "request_uri": {
                return new NginxUriNode(name);
            }
            case "server_protocol": {
                return new LvLayoutRegexNode(name, "http_protocol", Pattern.compile("HTTP/\\d\\.\\d"));
            }
            case "status": {
                return new NginxOptionalNumber(name, "number/nginx_response_code");
            }
            case "http_referer": {
                return new NginxUriNode(name);
            }
            case "http_user_agent": {
                return new NginxStretchPatternNode(name, "text/user-agent", true, Pattern.compile("[a-z\\-]+/\\d+\\.\\d+(?:\\.\\d+)? *(?:\\([\\w ,.;\\-/]+\\))?", 2));
            }
            case "request_time": {
                return new LvLayoutNumberNode(name, "number/interval_seconds/nginx_request_time", false, true);
            }
            case "request_id": {
                return new LvLayoutHexNode(name, "hex/nginx_request_id", 30);
            }
            case "any": {
                return new LvLayoutStretchNode("message", "message", false, 0);
            }
        }
        throw new IllegalArgumentException("Unexpected field: $" + name);
    }

    @Override
    public String getHumanReadableString() {
        return "nginx: " + this.getPattern();
    }
}

