/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.logLibs.logback;

import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.pattern.parser.SimpleKeywordNode;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.util.OptionHelper;
import com.logviewer.formats.AbstractPatternLogFormat;
import com.logviewer.formats.utils.LvLayoutClassNode;
import com.logviewer.formats.utils.LvLayoutFixedTextNode;
import com.logviewer.formats.utils.LvLayoutLog4jISO8601Date;
import com.logviewer.formats.utils.LvLayoutNode;
import com.logviewer.formats.utils.LvLayoutNumberNode;
import com.logviewer.formats.utils.LvLayoutRegexNode;
import com.logviewer.formats.utils.LvLayoutSimpleDateNode;
import com.logviewer.formats.utils.LvLayoutStretchNode;
import com.logviewer.formats.utils.LvLayoutTextNode;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.slf4j.event.Level;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class LogbackLogFormat
extends AbstractPatternLogFormat {
    private static final String[] ADDITIONAL_LEVEL_NAMES = new String[]{"WARNING"};
    protected static final int NODE_LITERAL = 0;
    protected static final int NODE_SIMPLE_KEYWORD = 1;
    protected static final int NODE_COMPOSITE_KEYWORD = 2;

    public LogbackLogFormat(@NonNull String pattern) {
        super(null, pattern);
    }

    public LogbackLogFormat(@Nullable Charset charset, @NonNull String pattern) {
        super(charset, pattern);
    }

    @Override
    protected LvLayoutNode[] parseLayout(@NonNull String pattern) throws IllegalArgumentException {
        try {
            Parser parser = new Parser(pattern);
            Node t = parser.parse();
        }
        catch (ScanException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        ArrayList<LvLayoutNode> nodes = new ArrayList<LvLayoutNode>();
        for (Node n = t; n != null; n = n.getNext()) {
            LvLayoutNode lvNode = LogbackLogFormat.createNode(n, pattern);
            if (lvNode == null) continue;
            nodes.add(lvNode);
        }
        LogbackLogFormat.mergeMessageFields(nodes);
        return nodes.toArray(new LvLayoutNode[0]);
    }

    private static LvLayoutNode createNode(Node n, String pattern) {
        switch (n.getType()) {
            case 0: {
                return LvLayoutTextNode.of((String)n.getValue());
            }
            case 2: {
                throw new IllegalArgumentException("log encoder pattern contains unsupported terms [pattern=\"" + pattern + "\", term=" + n + "]");
            }
            case 1: {
                String keyword;
                SimpleKeywordNode kn = (SimpleKeywordNode)n;
                switch (keyword = (String)kn.getValue()) {
                    case "d": 
                    case "date": {
                        String datePattern;
                        if (kn.getOptions() == null || kn.getOptions().isEmpty()) {
                            datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
                        } else {
                            datePattern = (String)kn.getOptions().get(0);
                            if (datePattern.equals("ISO8601")) {
                                datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
                            }
                            try {
                                new SimpleDateFormat(datePattern);
                            }
                            catch (IllegalArgumentException e) {
                                datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
                            }
                        }
                        LvLayoutLog4jISO8601Date res = LvLayoutLog4jISO8601Date.fromPattern(datePattern);
                        return res != null ? res : new LvLayoutSimpleDateNode(datePattern);
                    }
                    case "c": 
                    case "lo": 
                    case "logger": 
                    case "C": 
                    case "class": {
                        return new LvLayoutClassNode();
                    }
                    case "F": 
                    case "file": {
                        return new LvLayoutRegexNode("sourceFile", "sourceFile", "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.[a-z]{1,5}");
                    }
                    case "t": 
                    case "thread": {
                        return LvLayoutStretchNode.threadNode();
                    }
                    case "relative": 
                    case "r": {
                        return new LvLayoutNumberNode("relativeTime", "relativeTimestamp");
                    }
                    case "M": 
                    case "method": {
                        return new LvLayoutRegexNode("method", null, "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
                    }
                    case "L": 
                    case "line": {
                        return new LvLayoutNumberNode("line", null, true);
                    }
                    case "processId": {
                        return new LvLayoutNumberNode("pid", "number/processId");
                    }
                    case "p": 
                    case "le": 
                    case "level": {
                        return new LvLayoutFixedTextNode("level", "level/logback", (String[])Stream.concat(Stream.of(Level.values()).map(Level::toString), Stream.of(ADDITIONAL_LEVEL_NAMES)).toArray(String[]::new));
                    }
                    case "nopex": 
                    case "nopexception": 
                    case "n": {
                        return null;
                    }
                    case "X": 
                    case "mdc": {
                        if (!LogbackLogFormat.isNextLiteralOrEnd(kn)) {
                            return LvLayoutStretchNode.messageNode();
                        }
                        if (kn.getOptions() == null || kn.getOptions().isEmpty()) {
                            return new LvLayoutStretchNode("mdc", "mdc", true, 0);
                        }
                        String mdcPropertyName = LogbackLogFormat.getMdcPropertyName((String)kn.getOptions().get(0));
                        return new LvLayoutStretchNode(mdcPropertyName, "mdc", true, 0);
                    }
                    case "ex": 
                    case "exception": 
                    case "throwable": 
                    case "xEx": 
                    case "xException": 
                    case "xThrowable": 
                    case "wEx": 
                    case "wex": 
                    case "m": 
                    case "msg": 
                    case "message": {
                        return LvLayoutStretchNode.messageNode();
                    }
                }
                throw new IllegalArgumentException("log encoder pattern contains unsupported terms [pattern=\"" + pattern + "\", term=" + n + "]");
            }
        }
        throw new IllegalArgumentException("Unknown node type: " + n.getType() + ", pattern=" + pattern);
    }

    private static String getMdcPropertyName(String s) {
        String[] strings = OptionHelper.extractDefaultReplacement((String)s);
        return strings[0];
    }

    private static boolean isNextLiteralOrEnd(SimpleKeywordNode kn) {
        Node next = kn.getNext();
        return next == null || next.getType() == 0;
    }

    @Override
    public String getHumanReadableString() {
        return "logback: " + this.getPattern();
    }
}

