/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.formats.utils;

import com.logviewer.formats.utils.FastDateTimeParser;
import com.logviewer.formats.utils.LvLayoutDateNode;
import com.logviewer.utils.LvDateUtils;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.TimeZone;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class LvLayoutSimpleDateNode
extends LvLayoutDateNode {
    private final String format;
    private transient BiFunction<String, ParsePosition, Supplier<Instant>> formatter;
    protected transient Supplier<Instant> timestamp;

    public LvLayoutSimpleDateNode(@NonNull String format) {
        this(format, null);
    }

    public LvLayoutSimpleDateNode(@NonNull String format, @Nullable TimeZone zone) {
        super(zone);
        this.format = format;
        FastDateTimeParser.createFormatter(format, null);
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public int parse(String s, int offset, int end) {
        ParsePosition position = new ParsePosition(offset);
        if (this.formatter == null) {
            this.formatter = FastDateTimeParser.createFormatter(this.format, this.zone);
        }
        this.timestamp = this.formatter.apply(s, position);
        if (this.timestamp == null || position.getIndex() > end) {
            this.currentDate = -1L;
            return -2147483647;
        }
        return position.getIndex();
    }

    @Override
    public long getCurrentDate() {
        Instant instant = this.timestamp.get();
        return LvDateUtils.toNanos(instant);
    }

    @Override
    public boolean isFull() {
        return LvDateUtils.isDateFormatFull(new SimpleDateFormat(this.format));
    }

    @Override
    public LvLayoutDateNode clone() {
        return new LvLayoutSimpleDateNode(this.format, this.zone);
    }
}

