/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.formats;

import com.logviewer.data2.DefaultFieldDesciptor;
import com.logviewer.data2.LogFormat;
import com.logviewer.data2.LogReader;
import com.logviewer.data2.LogRecord;
import com.logviewer.formats.utils.FastDateTimeParser;
import com.logviewer.utils.LvDateUtils;
import com.logviewer.utils.Utils;
import java.nio.charset.Charset;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class RegexLogFormat
implements LogFormat,
Cloneable {
    private Charset charset;
    private String regex;
    private RegexField[] fields;
    private boolean dontAppendUnmatchedTextToLastField;
    private Integer dateFieldIdx;
    private String dateFieldName;
    private String datePattern;
    private volatile transient Pattern pattern;

    public RegexLogFormat(@NonNull Charset charset, @NonNull String regex, boolean dontAppendUnmatchedTextToLastField, RegexField ... fields) {
        this(charset, regex, dontAppendUnmatchedTextToLastField, (String)null, (String)null, fields);
    }

    public RegexLogFormat(@Nullable Charset charset, @NonNull String regex, boolean dontAppendUnmatchedTextToLastField, @Nullable String datePattern, @Nullable String dateFieldName, RegexField ... fields) {
        this.regex = regex;
        this.charset = charset;
        this.fields = fields;
        this.dontAppendUnmatchedTextToLastField = dontAppendUnmatchedTextToLastField;
        this.datePattern = datePattern;
        if (dateFieldName != null) {
            if (Stream.of(fields).noneMatch(f -> f.name().equals(dateFieldName))) {
                throw new IllegalArgumentException("Field not found: " + dateFieldName);
            }
            this.dateFieldName = dateFieldName;
        }
        this.validate();
    }

    public boolean isDontAppendUnmatchedTextToLastField() {
        return this.dontAppendUnmatchedTextToLastField;
    }

    private Pattern getPattern() {
        Pattern res = this.pattern;
        if (res == null) {
            String regex = this.regex;
            if (regex == null || regex.isEmpty()) {
                throw new IllegalArgumentException("'regex' field is empty");
            }
            try {
                res = Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Invalid pattern [" + regex + "] " + e.getMessage(), e);
            }
            this.pattern = res;
        }
        return res;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        int groupCount = this.getPattern().matcher("").groupCount();
        HashSet<Object> usedGroups = new HashSet<Object>();
        for (RegexField field : this.fields) {
            if (field.name() == null || field.name().isEmpty()) {
                throw new IllegalArgumentException("Filed name can not be empty string");
            }
            if (!Utils.isIdentifier(field.name())) {
                throw new IllegalArgumentException("Invalid field name '" + field.name() + "'. Field names can contains only letters, digits and '_'");
            }
            if (field.groupIndex != null && field.groupIndex <= 0) {
                throw new IllegalArgumentException("Invalid group index in regex format, 'groupIndex' must be greater than 0");
            }
            if (field.groupIndex != null && field.groupIndex > groupCount) {
                throw new IllegalArgumentException("Invalid group index in regex format, 'groupIndex' is greater than regex group count (" + field.groupIndex + " > " + groupCount + ')');
            }
            if (usedGroups.add(field.groupIndex == null ? field.name() : field.groupIndex)) continue;
            throw new IllegalArgumentException("Two fields has reference to same regex group: " + field.groupIndex);
        }
        if (this.dateFieldIdx != null || this.dateFieldName != null) {
            if (this.dateFieldIdx != null && this.dateFieldIdx >= this.fields.length) {
                throw new IllegalArgumentException("Invalid 'dateFieldIdx': " + this.dateFieldIdx + " >= " + this.fields.length);
            }
            if (this.dateFieldName != null && Stream.of(this.fields).noneMatch(f -> f.name().equals(this.dateFieldName))) {
                throw new IllegalArgumentException("Invalid 'dateFieldName': no field with name \"" + this.dateFieldName + '\"');
            }
            if (this.datePattern == null) {
                throw new IllegalArgumentException("'dateFieldIdx' is specified, but 'datePattern' is null");
            }
            if (!LvDateUtils.isDateFormatFull(new SimpleDateFormat(this.datePattern))) {
                throw new IllegalArgumentException("Invalid date format. Format must include date and time");
            }
            FastDateTimeParser.createFormatter(this.datePattern, null);
        } else if (this.datePattern != null) {
            throw new IllegalArgumentException("'datePattern' argument must be null if 'dateField' is null");
        }
    }

    @Override
    public String getHumanReadableString() {
        return "regexp: " + this.regex;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    @Override
    public LogReader createReader() {
        return new RegexReader();
    }

    @Override
    public LogFormat.FieldDescriptor[] getFields() {
        return this.fields;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public boolean hasFullDate() {
        return this.dateFieldIdx != null || this.dateFieldName != null;
    }

    public static RegexField field(@NonNull String name, @Nullable String type) {
        return RegexLogFormat.field(name, type, null);
    }

    public static RegexField field(@NonNull String name, @Nullable String type, @Nullable Integer groupIndex) {
        return new RegexField(name, groupIndex, type);
    }

    public static class RegexField
    extends DefaultFieldDesciptor {
        private final Integer groupIndex;

        public RegexField(@NonNull String name) {
            this(name, null, null);
        }

        public RegexField(@NonNull String name, Integer groupIndex) {
            this(name, groupIndex, null);
        }

        public RegexField(@NonNull String name, Integer groupIndex, @Nullable String type) {
            super(name, type);
            this.groupIndex = groupIndex;
        }
    }

    private class RegexReader
    extends LogReader {
        private String s;
        private long start;
        private long end;
        private boolean hasMore;
        private BiFunction<String, ParsePosition, Supplier<Instant>> dateFormat;
        private final Charset charset;
        private final int[] fields;
        private final Map<String, Integer> fieldNames;

        public RegexReader() {
            this.charset = RegexLogFormat.this.charset == null ? Charset.defaultCharset() : RegexLogFormat.this.charset;
            this.fields = new int[RegexLogFormat.this.fields.length * 2];
            this.fieldNames = new LinkedHashMap<String, Integer>();
            for (int i = 0; i < RegexLogFormat.this.fields.length; ++i) {
                this.fieldNames.put(RegexLogFormat.this.fields[i].name(), i);
            }
        }

        @Override
        public boolean parseRecord(byte[] data, int offset, int length, long start, long end) {
            String s = new String(data, offset, length, this.charset);
            Matcher matcher = RegexLogFormat.this.getPattern().matcher(s);
            if (!matcher.matches()) {
                return false;
            }
            this.s = s;
            this.start = start;
            this.end = end;
            this.hasMore = (long)length < end - start;
            for (int fieldIndex = 0; fieldIndex < RegexLogFormat.this.fields.length; ++fieldIndex) {
                RegexField field = RegexLogFormat.this.fields[fieldIndex];
                Integer groupIdx = field.groupIndex;
                int groupStart = groupIdx != null ? matcher.start(groupIdx) : matcher.start(field.name());
                if (groupStart >= 0) {
                    this.fields[fieldIndex * 2] = groupStart;
                    if (groupIdx != null) {
                        this.fields[fieldIndex * 2 + 1] = matcher.end(groupIdx);
                        continue;
                    }
                    this.fields[fieldIndex * 2 + 1] = matcher.end(field.name());
                    continue;
                }
                this.fields[fieldIndex * 2] = -1;
                this.fields[fieldIndex * 2 + 1] = -1;
            }
            return true;
        }

        @Override
        public boolean canAppendTail() {
            return !RegexLogFormat.this.dontAppendUnmatchedTextToLastField && this.fields.length > 0;
        }

        @Override
        public void appendTail(byte[] data, int offset, int length, long realLength) {
            if (this.s == null || RegexLogFormat.this.dontAppendUnmatchedTextToLastField) {
                throw new IllegalStateException();
            }
            if (this.fields.length == 0) {
                throw new IllegalStateException();
            }
            if (length == 0) {
                return;
            }
            this.end += realLength;
            if (this.hasMore) {
                return;
            }
            int lastField = RegexLogFormat.this.fields.length - 1;
            if (this.fields[lastField * 2] == -1) {
                assert (this.fields[lastField * 2 + 1] == -1);
                this.fields[lastField * 2] = this.s.length();
            } else if (this.fields[lastField * 2 + 1] != this.s.length()) {
                throw new IllegalStateException("Failed to append text to the last field, the last field '" + RegexLogFormat.this.fields[lastField].name() + "' is not on the end of line");
            }
            this.s = this.s + new String(data, offset, length, this.charset);
            this.fields[lastField * 2 + 1] = this.s.length();
        }

        @Override
        public boolean hasParsedRecord() {
            return this.s != null;
        }

        @Override
        public void clear() {
            this.s = null;
        }

        @Override
        public LogRecord buildRecord() {
            if (this.s == null) {
                throw new IllegalStateException();
            }
            long time = 0L;
            Integer dateFieldIdx = RegexLogFormat.this.dateFieldIdx;
            if (dateFieldIdx == null && RegexLogFormat.this.dateFieldName != null) {
                dateFieldIdx = this.fieldNames.get(RegexLogFormat.this.dateFieldName);
            }
            if (dateFieldIdx != null && this.fields[dateFieldIdx * 2] >= 0) {
                Supplier<Instant> timestamp;
                if (this.dateFormat == null) {
                    this.dateFormat = FastDateTimeParser.createFormatter(RegexLogFormat.this.datePattern, null);
                }
                if ((timestamp = this.dateFormat.apply(this.s, new ParsePosition(this.fields[dateFieldIdx * 2]))) != null) {
                    Instant instant = timestamp.get();
                    time = LvDateUtils.toNanos(instant);
                }
            }
            LogRecord res = new LogRecord(this.s, time, this.start, this.end, this.hasMore, (int[])this.fields.clone(), this.fieldNames);
            this.s = null;
            return res;
        }
    }
}

