/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.filters;

import com.logviewer.data2.FieldTypes;
import com.logviewer.data2.LogFilterContext;
import com.logviewer.data2.LogFormat;
import com.logviewer.data2.LogRecord;
import com.logviewer.filters.RecordPredicate;
import java.util.List;

public class FieldValueSetPredicate
implements RecordPredicate {
    private String fieldType;
    private List<String> values;

    public FieldValueSetPredicate() {
    }

    public FieldValueSetPredicate(String fieldType, List<String> values) {
        this.fieldType = fieldType;
        this.values = values;
    }

    @Override
    public boolean test(LogRecord record, LogFilterContext ctx) {
        if (this.fieldType == null || this.values == null) {
            return false;
        }
        LogFormat.FieldDescriptor[] fields = ctx.getFields();
        for (int i = 0; i < fields.length; ++i) {
            String fieldValue;
            LogFormat.FieldDescriptor field = fields[i];
            if (!FieldTypes.is(field.type(), this.fieldType) || (fieldValue = record.getFieldText(field.name())) == null || !this.values.contains(fieldValue)) continue;
            return true;
        }
        return false;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }
}

