/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2.net.server;

import com.logviewer.data2.net.server.api.RemoteTask;
import com.logviewer.data2.net.server.api.RemoteTaskContext;
import com.logviewer.web.session.LogProcess;
import org.springframework.lang.NonNull;

public abstract class AbstractDataLoaderTask<T>
implements RemoteTask<T> {
    protected Long initialTimeLimit;
    protected LogProcess logProcess;

    protected abstract LogProcess createLogProcessTask(RemoteTaskContext<T> var1);

    @Override
    public final void start(@NonNull RemoteTaskContext<T> ctx) {
        assert (this.logProcess == null);
        this.logProcess = this.createLogProcessTask(ctx);
        if (this.initialTimeLimit != null) {
            this.logProcess.setTimeLimit(this.initialTimeLimit);
        }
        this.logProcess.start();
    }

    public void setTimeLimit(long timeLimit) {
        if (this.logProcess != null) {
            this.logProcess.setTimeLimit(timeLimit);
        } else {
            this.initialTimeLimit = timeLimit;
        }
    }

    @Override
    public void cancel() {
        this.logProcess.cancel();
    }
}

