/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2.net;

import com.logviewer.data2.net.AbstractConnection;
import com.logviewer.data2.net.Node;
import com.logviewer.data2.net.server.api.RemoteContext;
import com.logviewer.data2.net.server.api.RemoteTask;
import com.logviewer.data2.net.server.api.RemoteTaskContext;
import com.logviewer.data2.net.server.api.RemoteTaskController;
import com.logviewer.data2.net.server.msg.MessageStartTask;
import com.logviewer.data2.net.server.msg.MessageTaskCallbackCall;
import com.logviewer.data2.net.server.msg.MessageTaskChangeEvent;
import java.io.IOException;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutcomeConnection
extends AbstractConnection {
    private static final Logger LOG = LoggerFactory.getLogger(OutcomeConnection.class);
    private final Node node;
    private final Map<Long, RemoteTaskControllerImpl> tasks = new HashMap<Long, RemoteTaskControllerImpl>();
    private long callCounter = 0L;

    OutcomeConnection(Node node, AsynchronousSocketChannel socket) {
        super(socket);
        this.node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleMessage(Object msg) {
        block10: {
            if (msg instanceof MessageTaskCallbackCall) {
                RemoteTaskControllerImpl controller;
                MessageTaskCallbackCall message = (MessageTaskCallbackCall)msg;
                OutcomeConnection outcomeConnection = this;
                synchronized (outcomeConnection) {
                    controller = message.isTaskStopped() ? this.tasks.remove(message.getTaskId()) : this.tasks.get(message.getTaskId());
                }
                if (controller == null || controller.canceled) {
                    return;
                }
                try {
                    if (message.getError() != null) {
                        assert (message.getEvent() == null);
                        controller.callback.accept(null, message.getError());
                        break block10;
                    }
                    controller.callback.accept(message.getEvent(), null);
                }
                catch (Throwable e) {
                    LOG.error("Failed to call callback", e);
                }
            } else {
                LOG.error("Unknown message: {}", msg);
            }
        }
    }

    public <R> CompletableFuture<R> execute(Function<RemoteContext, R> task) {
        CompletableFuture future = new CompletableFuture();
        RemoteTaskController taskController = this.startTask(new TaskWrapper<R>(task), (res, e) -> {
            if (e != null) {
                future.completeExceptionally((Throwable)e);
            } else {
                future.complete(res);
            }
        });
        future.whenComplete((res, e) -> {
            if (e instanceof CancellationException) {
                taskController.cancel();
            }
        });
        return future;
    }

    public synchronized <E, T extends RemoteTask<E>> RemoteTaskController<T> startTask(T task, BiConsumer<E, Throwable> callback) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        long taskId = ++this.callCounter;
        RemoteTaskControllerImpl controller = new RemoteTaskControllerImpl(taskId, callback);
        this.tasks.put(taskId, controller);
        this.sendMessage(new MessageStartTask(taskId, task));
        return controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onDisconnect() {
        ArrayList<RemoteTaskControllerImpl> consumers;
        IOException e = new IOException("Disconnected");
        OutcomeConnection outcomeConnection = this;
        synchronized (outcomeConnection) {
            this.closed = true;
            consumers = new ArrayList<RemoteTaskControllerImpl>(this.tasks.values());
            this.tasks.clear();
        }
        for (RemoteTaskControllerImpl controller : consumers) {
            try {
                if (controller.canceled) continue;
                controller.callback.accept(null, e);
            }
            catch (Throwable ex) {
                LOG.error("Failed to call callback", (Throwable)e);
            }
        }
    }

    private class RemoteTaskControllerImpl<E, T extends RemoteTask<E>>
    implements RemoteTaskController<T> {
        private final long taskId;
        private final BiConsumer<E, Throwable> callback;
        private volatile boolean canceled;

        RemoteTaskControllerImpl(long taskId, BiConsumer<E, Throwable> callback) {
            this.taskId = taskId;
            this.callback = callback;
        }

        @Override
        public void alterTask(Consumer<T> modifier) {
            OutcomeConnection.this.sendMessage(new MessageTaskChangeEvent(this.taskId, modifier));
        }

        @Override
        public void cancel() {
            if (!this.canceled) {
                this.canceled = true;
                OutcomeConnection.this.sendMessage(new MessageTaskChangeEvent(this.taskId, null));
            }
        }
    }

    private static class TaskWrapper<R>
    implements RemoteTask<R> {
        private final Function<RemoteContext, R> task;
        private Future<?> future;

        TaskWrapper(Function<RemoteContext, R> task) {
            this.task = task;
        }

        @Override
        public void start(RemoteTaskContext<R> ctx) {
            this.future = ctx.getLogService().getExecutor().submit(() -> {
                try {
                    R res = this.task.apply(ctx);
                    if (this.future.isCancelled()) {
                        return;
                    }
                    ctx.sendAndCloseChannel(res);
                }
                catch (Throwable e) {
                    if (this.future.isCancelled()) {
                        return;
                    }
                    ctx.sendErrorAndCloseChannel(e);
                }
            });
        }

        @Override
        public void cancel() {
            this.future.cancel(true);
        }
    }
}

