/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2;

import com.google.gson.annotations.JsonAdapter;
import com.logviewer.data2.LogRecord;
import com.logviewer.utils.GsonNanosecondsAdapter;
import com.logviewer.utils.LvDateUtils;
import com.logviewer.utils.Utils;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Objects;

public class Position
implements Comparable<Position>,
Serializable {
    private final String logId;
    @JsonAdapter(value=GsonNanosecondsAdapter.class)
    private final Long time;
    private final long o;

    public Position(String logId, Date date, long o) {
        this(logId, LvDateUtils.toNanos(date), o);
    }

    public Position(String logId, long time, long o) {
        Utils.assertValidTimestamp(time);
        this.logId = logId;
        this.time = time;
        this.o = o;
    }

    public Position(LogRecord record) {
        this(record, true);
    }

    public Position(LogRecord record, boolean atStart) {
        this(record.getLogId(), record.getTime(), atStart ? record.getStart() : record.getEnd());
    }

    public String getLogId() {
        return this.logId;
    }

    public long getTime() {
        return this.time;
    }

    public long getLocalPosition() {
        return this.o;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Position position = (Position)o;
        if (!Objects.equals(this.time, position.time)) {
            return false;
        }
        if (this.o != position.o) {
            return false;
        }
        return this.logId.equals(position.logId);
    }

    public int hashCode() {
        int result = this.logId.hashCode();
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        result = 31 * result + (int)(this.o ^ this.o >>> 32);
        return result;
    }

    @Override
    public int compareTo(Position o) {
        int res = Long.compare(this.time, o.time);
        if (res == 0 && (res = this.logId.compareTo(o.logId)) == 0) {
            res = Long.compare(this.o, o.o);
        }
        return res;
    }

    public String toString() {
        return this.logId + " - " + DateFormat.getDateTimeInstance().format(new Date(this.time)) + " - " + this.o;
    }
}

