/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2;

import com.logviewer.data2.net.Node;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class LogPath
implements Serializable {
    private static final Pattern HOST_REGEX = Pattern.compile("((?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9]))(?::(\\d{1,5}))?");
    private final Node node;
    private final String file;

    public LogPath(@Nullable Node node, @NonNull String file) {
        this.node = node;
        this.file = file;
    }

    @Nullable
    public Node getNode() {
        return this.node;
    }

    @NonNull
    public String getFile() {
        return this.file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogPath logPath = (LogPath)o;
        if (!Objects.equals(this.node, logPath.node)) {
            return false;
        }
        return this.file.equals(logPath.file);
    }

    public int hashCode() {
        int result = this.node != null ? this.node.hashCode() : 0;
        result = 31 * result + this.file.hashCode();
        return result;
    }

    public static List<LogPath> parsePathFromHttpParameter(@NonNull String path) {
        int pathStart = (path = path.trim()).lastIndexOf(64);
        if (pathStart < 0) {
            if (path.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(new LogPath(null, path));
        }
        String file = path.substring(0, pathStart);
        if (file.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<LogPath> res = new ArrayList<LogPath>();
        for (String hostAndPort : path.substring(pathStart + 1).split(",")) {
            Matcher matcher = HOST_REGEX.matcher(hostAndPort);
            if (!matcher.matches()) continue;
            String host = matcher.group(1);
            Integer port = matcher.group(2) == null ? null : new Integer(matcher.group(2));
            res.add(new LogPath(new Node(host, port), file));
        }
        return res;
    }

    public String toString() {
        if (this.node == null) {
            return this.file;
        }
        return this.node + ": " + this.file;
    }
}

