/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2;

import com.logviewer.api.LvFileAccessManager;
import com.logviewer.data2.BufferedFile;
import com.logviewer.data2.DirectoryNotVisibleException;
import com.logviewer.data2.FileAttributes;
import com.logviewer.data2.FileWatcherService;
import com.logviewer.data2.IncorrectFormatException;
import com.logviewer.data2.LogCrashedException;
import com.logviewer.data2.LogFormat;
import com.logviewer.data2.LogIndex;
import com.logviewer.data2.LogPath;
import com.logviewer.data2.LogReader;
import com.logviewer.data2.LogRecord;
import com.logviewer.data2.LogView;
import com.logviewer.data2.Position;
import com.logviewer.data2.Snapshot;
import com.logviewer.filters.RecordPredicate;
import com.logviewer.utils.Destroyer;
import com.logviewer.utils.LvGsonUtils;
import com.logviewer.utils.LvTimer;
import com.logviewer.utils.MultiListener;
import com.logviewer.utils.Utils;
import com.logviewer.web.session.LocalFileRecordLoader;
import com.logviewer.web.session.LocalFileRecordSearcher;
import com.logviewer.web.session.LogDataListener;
import com.logviewer.web.session.LogProcess;
import com.logviewer.web.session.SearchResult;
import com.logviewer.web.session.tasks.SearchPattern;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class Log
implements LogView {
    private static final Logger LOG = LoggerFactory.getLogger(Log.class);
    public static Function<String, String> DEFAULT_ID_GENERATOR = path -> {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            Utils.putUnencodedChars(digest, Utils.LOCAL_HOST_NAME);
            digest.update((byte)124);
            Utils.putUnencodedChars(digest, path);
            long hash = ByteBuffer.wrap(digest.digest()).getLong();
            return Long.toHexString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    };
    public static Function<String, String> LOG_ID_GENERATOR = DEFAULT_ID_GENERATOR;
    public static final long CHANGE_NOTIFICATION_TIMEOUT = 50L;
    private final Object logChangedTaskKey = new Object();
    private final Path file;
    private final String id;
    private final LogFormat format;
    private final Charset encoding;
    private long cachedHashTimestamp;
    private String cachedHash;
    private final ExecutorService executor;
    @Autowired
    private LvTimer timer;
    @Autowired
    private FileWatcherService fileWatcherService;
    @Autowired
    private LvFileAccessManager accessManager;
    @Value(value="${log-viewer.parser.max-unparsable-block-size:2097152}")
    private long unparsableBlockMaxSize;
    private final MultiListener<Consumer<FileAttributes>> changeListener = new MultiListener(this::createFileListener);
    private LogIndex logIndex;

    public Log(@NonNull Path path, @NonNull LogFormat format, @NonNull ExecutorService executor) {
        this.file = path;
        this.format = LvGsonUtils.copy(format);
        this.executor = executor;
        this.encoding = this.format.getCharset() == null ? Charset.defaultCharset() : this.format.getCharset();
        this.id = LOG_ID_GENERATOR.apply(path.toString());
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Path getFile() {
        return this.file;
    }

    @Override
    public LogPath getPath() {
        return new LogPath(null, this.file.toString());
    }

    @Override
    public String getHostname() {
        return Utils.LOCAL_HOST_NAME;
    }

    @Override
    public LogFormat getFormat() {
        return this.format;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    private LogRecord createUnparsedRecord(BufferedFile buf, long start, long end) throws IOException {
        long readLength = Math.min(end - start, 32768L);
        ByteBuffer b = buf.read(start, readLength);
        String text = Utils.toString(b, this.encoding);
        return LogRecord.createUnparsedRecord(text, 0L, start, end, readLength < end - start).setLogId(this.id);
    }

    public Snapshot createSnapshot() {
        while (true) {
            try {
                return new LogSnapshot();
            }
            catch (LogCrashedException logCrashedException) {
                continue;
            }
            break;
        }
    }

    @Override
    public LogProcess loadRecords(RecordPredicate filter, int recordCountLimit, @Nullable Position start, boolean backward, String hash, long sizeLimit, @NonNull LogDataListener loadListener) {
        return new LocalFileRecordLoader(this::createSnapshot, this.executor, loadListener, start, filter, backward, recordCountLimit, sizeLimit, hash);
    }

    @Override
    public LogProcess createRecordSearcher(@NonNull Position start, boolean backward, RecordPredicate recordPredicate, @Nullable String hash, int recordCount, @NonNull SearchPattern searchPattern, @NonNull Consumer<SearchResult> listener) {
        return new LocalFileRecordSearcher(this::createSnapshot, this.executor, start, backward, recordPredicate, hash, recordCount, searchPattern, listener);
    }

    private void notifyLogChanged() {
        FileAttributes attr;
        try {
            attr = FileAttributes.fromPath(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending notification about log changing {}", (Object)this.file);
        }
        for (Consumer<FileAttributes> listener : this.changeListener.getListeners()) {
            try {
                listener.accept(attr);
            }
            catch (Throwable e) {
                LOG.error("Failed to notify listener", e);
            }
        }
    }

    private Destroyer createFileListener() {
        try {
            return this.fileWatcherService.watchDirectory(this.file.toAbsolutePath().getParent(), files -> {
                if (files.contains(this.file)) {
                    boolean scheduled = this.timer.scheduleTask(this.logChangedTaskKey, this::notifyLogChanged, 50L);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Scheduled notification about log changes {}, [new timer task={}]", (Object)this.file, (Object)scheduled);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Destroyer addChangeListener(Consumer<FileAttributes> changeListener) {
        return this.changeListener.addListener(changeListener);
    }

    @Override
    public CompletableFuture<Throwable> tryRead() {
        try (Snapshot snapshot = this.createSnapshot();){
            CompletableFuture<Throwable> completableFuture = CompletableFuture.completedFuture(snapshot.getError());
            return completableFuture;
        }
    }

    public String toString() {
        return this.file.toString();
    }

    public static void setLogIdGenerator(Function<String, String> logIdGenerator) {
        LOG_ID_GENERATOR = logIdGenerator;
    }

    public class LogSnapshot
    implements Snapshot {
        private final long size;
        private final long lastModification;
        private final IOException error;
        private final String hash;
        private SeekableByteChannel channel;
        private BufferedFile buf;
        private final LogIndex logIndex;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LogSnapshot() throws LogCrashedException {
            long size = 0L;
            long lastModification = 0L;
            IOException error = null;
            String hash = null;
            LogIndex logIndex = null;
            Log log = Log.this;
            synchronized (log) {
                boolean success = false;
                try {
                    if (!Log.this.file.isAbsolute()) {
                        throw new NoSuchFileException(Log.this.file.toString());
                    }
                    if (!Log.this.accessManager.isFileVisible(Log.this.file)) {
                        throw new DirectoryNotVisibleException(Log.this.file.toString(), Log.this.accessManager.errorMessage(Log.this.file));
                    }
                    BasicFileAttributes attrs = Files.readAttributes(Log.this.file, BasicFileAttributes.class, new LinkOption[0]);
                    if (!attrs.isRegularFile()) {
                        throw new IOException("Not a file");
                    }
                    size = attrs.size();
                    lastModification = attrs.lastModifiedTime().toMillis();
                    if (Log.this.cachedHashTimestamp == lastModification) {
                        hash = Log.this.cachedHash;
                    } else {
                        hash = this.calculateHash(size);
                        if (!hash.equals(Log.this.cachedHash)) {
                            Log.this.logIndex = new LogIndex();
                        }
                        Log.this.cachedHash = hash;
                        Log.this.cachedHashTimestamp = lastModification;
                    }
                    logIndex = Log.this.logIndex;
                    success = true;
                }
                catch (IOException e) {
                    error = e;
                }
                finally {
                    if (!success) {
                        Utils.closeQuietly(this);
                    }
                }
            }
            this.size = size;
            this.lastModification = lastModification;
            this.error = error;
            this.hash = hash;
            this.logIndex = logIndex;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public long getLastModification() {
            return this.lastModification;
        }

        private SeekableByteChannel getChannel() throws IOException {
            if (this.channel == null) {
                if (this.error != null) {
                    throw new IOException(this.error);
                }
                this.channel = Files.newByteChannel(Log.this.file, StandardOpenOption.READ);
            }
            this.buf = new BufferedFile(this.channel, this.size);
            return this.channel;
        }

        private BufferedFile getBuffer() throws IOException {
            this.getChannel();
            return this.buf;
        }

        private void assertUnparsedBlockSize(long blockStart, long blockEnd) throws IncorrectFormatException {
            assert (blockStart <= blockEnd);
            if (blockEnd - blockStart > Log.this.unparsableBlockMaxSize) {
                throw new IncorrectFormatException(Log.this.file.toString(), blockStart, blockEnd, Log.this.format);
            }
        }

        private long findUnparsedEnd(BufferedFile buf, LogReader tmpReader, long lastLineEnd) throws IOException {
            long position = lastLineEnd;
            BufferedFile.Line line = new BufferedFile.Line();
            while (buf.loadNextLine(line, position) && !tmpReader.parseRecord(line)) {
                position = line.getEnd();
                this.assertUnparsedBlockSize(lastLineEnd, position);
            }
            return position;
        }

        private long findParsedBefore(BufferedFile buf, LogReader reader, BufferedFile.Line line, long lastLineStart) throws IOException {
            long position = lastLineStart;
            while (true) {
                if (!buf.loadPrevLine(line, position)) {
                    reader.clear();
                    return position;
                }
                if (reader.parseRecord(line)) {
                    return position;
                }
                position = line.getStart();
                this.assertUnparsedBlockSize(position, lastLineStart);
            }
        }

        private void appendTail(BufferedFile buf, LogReader reader, long unparsedStart, long unparsedEnd) throws IOException {
            long tailLength = unparsedEnd - unparsedStart;
            long readLength = Math.min(tailLength, 32768L);
            ByteBuffer b = buf.read(unparsedStart, readLength);
            reader.appendTail(b.array(), b.position(), b.remaining(), tailLength);
        }

        @Override
        public boolean processRecordsBack(long position, boolean fromPrevLine, Predicate<LogRecord> consumer) throws IOException {
            long lastProcessedLineStart;
            long unparsedStart;
            long unparsedEnd;
            if (position < 0L) {
                throw new IllegalArgumentException();
            }
            if (this.error != null) {
                throw this.error;
            }
            if (position > this.size) {
                position = this.size;
            }
            if (this.size == 0L) {
                return true;
            }
            BufferedFile buf = this.getBuffer();
            BufferedFile.Line firstLine = new BufferedFile.Line();
            if (fromPrevLine) {
                if (!buf.loadPrevLine(firstLine, position)) {
                    return true;
                }
            } else {
                buf.loadLine(firstLine, position);
            }
            LogReader reader = Log.this.format.createReader();
            LogReader tmpReader = Log.this.format.createReader();
            if (!reader.parseRecord(firstLine)) {
                unparsedEnd = this.findUnparsedEnd(buf, tmpReader, firstLine.getEnd());
                BufferedFile.Line line = new BufferedFile.Line();
                unparsedStart = this.findParsedBefore(buf, reader, line, firstLine.getStart());
                if (!reader.hasParsedRecord()) {
                    return consumer.test(Log.this.createUnparsedRecord(buf, unparsedStart, unparsedEnd));
                }
                lastProcessedLineStart = line.getStart();
                if (reader.canAppendTail()) {
                    this.appendTail(buf, reader, line.getEnd(), unparsedEnd);
                } else if (!consumer.test(Log.this.createUnparsedRecord(buf, unparsedStart, unparsedEnd))) {
                    return false;
                }
            } else {
                lastProcessedLineStart = firstLine.getStart();
                if (reader.canAppendTail() && (unparsedEnd = this.findUnparsedEnd(buf, tmpReader, firstLine.getEnd())) != firstLine.getEnd()) {
                    this.appendTail(buf, reader, firstLine.getEnd(), unparsedEnd);
                }
            }
            if (!consumer.test(reader.buildRecord().setLogId(Log.this.id))) {
                return false;
            }
            BufferedFile.Line line = new BufferedFile.Line();
            while (buf.loadPrevLine(line, lastProcessedLineStart)) {
                if (!reader.parseRecord(line)) {
                    long unparsedEnd2 = line.getEnd();
                    unparsedStart = this.findParsedBefore(buf, reader, line, line.getStart());
                    if (!reader.hasParsedRecord()) {
                        return consumer.test(Log.this.createUnparsedRecord(buf, unparsedStart, unparsedEnd2));
                    }
                    if (reader.canAppendTail()) {
                        this.appendTail(buf, reader, line.getEnd(), unparsedEnd2);
                    } else if (!consumer.test(Log.this.createUnparsedRecord(buf, unparsedStart, unparsedEnd2))) {
                        return false;
                    }
                }
                if (!consumer.test(reader.buildRecord().setLogId(Log.this.id))) {
                    return false;
                }
                lastProcessedLineStart = line.getStart();
            }
            return true;
        }

        @Override
        public boolean processRecords(long position, boolean fromNextLine, Predicate<LogRecord> consumer) throws IOException {
            if (position < 0L) {
                throw new IllegalArgumentException();
            }
            if (this.error != null) {
                throw this.error;
            }
            if (position > this.size) {
                return true;
            }
            if (this.size == 0L) {
                return true;
            }
            BufferedFile buf = this.getBuffer();
            BufferedFile.Line line = new BufferedFile.Line();
            if (fromNextLine) {
                if (!buf.loadNextLine(line, position)) {
                    return true;
                }
            } else {
                buf.loadLine(line, position);
            }
            LogReader reader = Log.this.format.createReader();
            LogReader forwardReader = Log.this.format.createReader();
            long selectedLineEnd = line.getEnd();
            if (!reader.parseRecord(line)) {
                long unparsedBlockStart = this.findParsedBefore(buf, reader, line, line.getStart());
                if (reader.hasParsedRecord()) {
                    long unparsedEnd;
                    long parsedLineEnd = line.getEnd();
                    long p = selectedLineEnd;
                    while (true) {
                        if (!buf.loadNextLine(line, p)) {
                            unparsedEnd = p;
                            break;
                        }
                        if (forwardReader.parseRecord(line)) {
                            unparsedEnd = p;
                            break;
                        }
                        p = line.getEnd();
                    }
                    if (reader.canAppendTail()) {
                        this.appendTail(buf, reader, parsedLineEnd, unparsedEnd);
                        if (!consumer.test(reader.buildRecord().setLogId(Log.this.id))) {
                            return false;
                        }
                    } else if (!consumer.test(Log.this.createUnparsedRecord(buf, unparsedBlockStart, unparsedEnd))) {
                        return false;
                    }
                    if (!forwardReader.hasParsedRecord()) {
                        return true;
                    }
                    LogReader tmp = reader;
                    reader = forwardReader;
                    forwardReader = tmp;
                } else {
                    long p = selectedLineEnd;
                    while (true) {
                        if (!buf.loadNextLine(line, p)) {
                            return consumer.test(Log.this.createUnparsedRecord(buf, unparsedBlockStart, p));
                        }
                        if (reader.parseRecord(line)) {
                            if (consumer.test(Log.this.createUnparsedRecord(buf, unparsedBlockStart, p))) break;
                            return false;
                        }
                        p = line.getEnd();
                        this.assertUnparsedBlockSize(unparsedBlockStart, p);
                    }
                }
            }
            while (true) {
                boolean hasNext;
                long prevEnd;
                assert (reader.hasParsedRecord());
                long parsedLineEnd = line.getEnd();
                long unparsedStart = -1L;
                while (true) {
                    prevEnd = line.getEnd();
                    boolean nexRecordParsed = false;
                    hasNext = buf.loadNextLine(line);
                    if (hasNext) {
                        nexRecordParsed = forwardReader.parseRecord(line);
                    }
                    if (!hasNext || nexRecordParsed) break;
                    if (unparsedStart != -1L) continue;
                    unparsedStart = line.getStart();
                }
                if (parsedLineEnd < prevEnd) {
                    assert (unparsedStart != -1L);
                    if (reader.canAppendTail()) {
                        this.appendTail(buf, reader, parsedLineEnd, prevEnd);
                        if (!consumer.test(reader.buildRecord().setLogId(Log.this.id))) {
                            return false;
                        }
                    } else {
                        if (!consumer.test(reader.buildRecord().setLogId(Log.this.id))) {
                            return false;
                        }
                        if (!consumer.test(Log.this.createUnparsedRecord(buf, unparsedStart, prevEnd))) {
                            return false;
                        }
                    }
                } else if (!consumer.test(reader.buildRecord().setLogId(Log.this.id))) {
                    return false;
                }
                if (!hasNext) {
                    return true;
                }
                LogReader tmp = reader;
                reader = forwardReader;
                forwardReader = tmp;
            }
        }

        @Override
        public boolean processFromTimeBack(long timestampNanos, Predicate<LogRecord> consumer) throws IOException {
            if (this.error != null) {
                throw this.error;
            }
            Utils.assertValidTimestamp(timestampNanos);
            LogRecord record = this.logIndex.findRecordBound(timestampNanos, true, (Snapshot)this);
            if (record == null) {
                return true;
            }
            if (!consumer.test(record)) {
                return false;
            }
            return this.processRecordsBack(record.getStart(), true, consumer);
        }

        @Override
        public boolean processFromTime(long timestampNanos, Predicate<LogRecord> consumer) throws IOException {
            if (this.error != null) {
                throw this.error;
            }
            Utils.assertValidTimestamp(timestampNanos);
            LogRecord record = this.logIndex.findRecordBound(timestampNanos, false, (Snapshot)this);
            if (record == null) {
                return true;
            }
            if (!consumer.test(record)) {
                return false;
            }
            return this.processRecords(record.getEnd(), true, consumer);
        }

        @Override
        public Exception getError() {
            return this.error;
        }

        @Override
        public Log getLog() {
            return Log.this;
        }

        private String calculateHash(long fileSize) throws LogCrashedException, IOException {
            int hashSize = this.hashSize(fileSize);
            ByteBuffer buf = ByteBuffer.allocate(hashSize);
            try {
                this.getChannel().position(0L);
                Utils.readFully(this.channel, buf);
                CRC32 crc = new CRC32();
                crc.update(buf.array());
                int hash = (int)crc.getValue();
                long hashWithLength = (long)hash & 0xFFFFFFFFL | (long)hashSize << 32;
                return Long.toHexString(hashWithLength);
            }
            catch (EOFException e) {
                throw new LogCrashedException();
            }
        }

        private int hashSize(long fileSize) {
            return (int)(Math.min(fileSize, 255L) & 0xFFL);
        }

        @Override
        public boolean isValidHash(@NonNull String hash) {
            long tLong = Long.parseUnsignedLong(hash, 16);
            int hashSize = (int)(tLong >>> 32 & 0xFFL);
            if (hashSize == this.hashSize(this.size)) {
                return hash.equals(this.hash);
            }
            try {
                return this.calculateHash(hashSize).equals(hash);
            }
            catch (LogCrashedException | IOException e) {
                return false;
            }
        }

        @Override
        public String getHash() {
            return this.hash;
        }

        @Override
        public void close() {
            if (this.channel != null) {
                Utils.closeQuietly(this.channel);
                this.channel = null;
            }
        }

        protected void finalize() {
            if (this.channel != null) {
                Utils.closeQuietly(this.channel);
                LOG.error("Unclosed Log.Snapshot");
            }
        }
    }
}

