/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.springboot;

import com.logviewer.web.LogViewerWebsocket;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;
import org.springframework.web.socket.server.standard.ServerEndpointRegistration;

@Configuration
@PropertySource(value={"classpath:log-viewer-springboot.properties"})
public class LogViewerWebsocketConfig {
    @Bean
    public ServerEndpointRegistration logViewerWebSocket(Environment environment) {
        String path = environment.getRequiredProperty("log-viewer.websocket.path");
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        String logServletPath = environment.getProperty("log-viewer.url-mapping", "/logs/*");
        logServletPath = logServletPath.replaceAll("/+\\**$", "");
        return new ServerEndpointRegistration(logServletPath + path, LogViewerWebsocket.class);
    }

    @ConditionalOnMissingBean(value={ServerEndpointExporter.class})
    @Bean
    public ServerEndpointExporter endpointExporter() {
        return new ServerEndpointExporter();
    }
}

